package cn.valot.common.data;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

/**
 * 日期工具类
 * @author sa@linkot.cn
 */
public class DateUtils {
    public static final Long MILLIS = 1L;
    public static final Long SECONDS = MILLIS * 1000;
    public static final Long MINUTES = SECONDS * 60;
    public static final Long HOURS = MINUTES * 60;
    public static final Long DAYS = HOURS * 24;
    // 两时间的差（毫秒）
    public static Long between(Date start, Date end){
        return end.getTime() - start.getTime();
    }
    // 两时间的差（秒）
    public static Long betweenSeconds(Date start, Date end){
        return between(start, end) / SECONDS;
    }
    // 两时间的差（分）
    public static Long betweenMinutes(Date start, Date end){
        return between(start, end) / MINUTES;
    }
    // 两时间的差（时）
    public static Long betweenHours(Date start, Date end){
        return between(start, end) / HOURS;
    }
    // 两时间的差（日）
    public static Long betweenDays(Date start, Date end){
        return between(start, end) / DAYS;
    }

    public static Date parseDate(String src, String fmt){
        SimpleDateFormat format = new SimpleDateFormat(fmt);
        try {
            return format.parse(src);
        } catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public static String parseString(Date src, String fmt){
        SimpleDateFormat format = new SimpleDateFormat(fmt);
        return format.format(src);
    }

    public static Date later(Long l) {
        return new Date(System.currentTimeMillis() + l);
    }

    public static Date year(String year) {
        Calendar instance = Calendar.getInstance();
        instance.set(Integer.parseInt(year), Calendar.JANUARY, 1, 0, 0, 0);
        return instance.getTime();
    }
}
