package cn.valot.common.data;

import org.springframework.lang.Nullable;

import java.util.Arrays;
import java.util.Collection;
import java.util.function.Predicate;

public final class Collections {
    public static boolean isEmpty(Collection<?> c){
        return c == null || c.size() == 0;
    }

    /**
     * 如果有空值
     */
    public static boolean isNull(Object... objects){
        for (Object o : objects) {
            if (o==null){
                return true;
            }
        }
        return false;
    }
    @SafeVarargs
    public static <T> T getNotNull(T... arr){
        for (T t : arr) {
            if (t != null){
                return t;
            }
        }
        return null;
    }
    @Nullable
    public static <T> T getOne(Collection<T> list, Predicate<T> predicate){
        if (list==null){
            return null;
        }
        return list.stream().filter(predicate).findFirst().orElse(null);
    }
    @Nullable
    public static <T> T getOne(T[] list, Predicate<T> predicate){
        if (list==null){
            return null;
        }
        return Arrays.stream(list).filter(predicate).findFirst().orElse(null);
    }

}
