package cn.valot.common.data;

public class Bytes {

    static private final int  BASELENGTH   = 128;
    static private final int  LOOKUPLENGTH = 16;
    static final private byte [] hexNumberTable    = new byte[BASELENGTH];
    static final private char [] lookUpHexAlphabet = new char[LOOKUPLENGTH];


    static {
        for (int i = 0; i < BASELENGTH; i++ ) {
            hexNumberTable[i] = -1;
        }
        for ( int i = '9'; i >= '0'; i--) {
            hexNumberTable[i] = (byte) (i-'0');
        }
        for ( int i = 'F'; i>= 'A'; i--) {
            hexNumberTable[i] = (byte) ( i-'A' + 10 );
        }
        for ( int i = 'f'; i>= 'a'; i--) {
            hexNumberTable[i] = (byte) ( i-'a' + 10 );
        }

        for(int i = 0; i<10; i++ ) {
            lookUpHexAlphabet[i] = (char)('0'+i);
        }
        for(int i = 10; i<=15; i++ ) {
            lookUpHexAlphabet[i] = (char)('A'+i -10);
        }
    }

    /**
     * bytes 添加前缀 byte
     * @param src byte 数组
     * @param prefix 前缀
     */
    public static byte[] appendPrefix(byte[] src, byte prefix){
        int l = src.length;
        byte[] buf = new byte[l + 1];
        buf[0] = prefix;
        System.arraycopy(src, 0, buf, 1, l);
        return buf;
    }

    /**
     * bytes 添加后缀 byte
     * @param src byte 数组
     * @param suffix 后缀
     */
    public static byte[] appendSuffix(byte[] src, byte suffix) {
        int l = src.length;
        byte[] buf = new byte[l + 1];
        buf[l] = suffix;
        System.arraycopy(src, 0, buf, 0, l);
        return buf;
    }

    /**
     * byte 数组相加
     * @param src 原数组
     * @param ele 相加的数组
     * @return src + ele
     */
    public static byte[] append(byte[] src, byte[] ele){
        byte[] buf = new byte[src.length + ele.length];
        System.arraycopy(src, 0, buf, 0, src.length);
        System.arraycopy(ele, 0, buf, src.length, ele.length);
        return buf;
    }

    /**
     * byte 数组相加 - 全部
     * @param src 原数组
     * @param ele 相加的数组
     * @return src + ele
     */
    public static byte[] appendAll(byte[] src, byte[]... ele){
        byte[] r = src.clone();
        for (byte[] buf : ele) {
            r = append(r, buf);
        }
        return r;
    }

    /**
     * 大小端转换
     */
    public static byte[] reverse(byte[] data){
        byte[] buf = new byte[data.length];
        for (int i = 0; i < data.length; i++) {
            buf[data.length - i - 1] = data[i];
        }
        return buf;
    }

    /**
     * Encode a byte array to hex string
     *
     * @param binaryData array of byte to encode
     * @return return encoded string
     */
    static public String encodeHex(byte[] binaryData) {
        if (binaryData == null)
            return null;
        int lengthData   = binaryData.length;
        int lengthEncode = lengthData * 2;
        char[] encodedData = new char[lengthEncode];
        int temp;
        for (int i = 0; i < lengthData; i++) {
            temp = binaryData[i];
            if (temp < 0)
                temp += 256;
            encodedData[i*2] = lookUpHexAlphabet[temp >> 4];
            encodedData[i*2+1] = lookUpHexAlphabet[temp & 0xf];
        }
        return new String(encodedData);
    }

    /**
     * Decode hex string to a byte array
     *
     * @param encoded encoded string
     * @return return array of byte to encode
     */
    static public byte[] decodeHex(String encoded) {
        if (encoded == null)
            return null;
        encoded = encoded.replaceAll(" ", "");
        int lengthData = encoded.length();
        if (lengthData % 2 != 0)
            return null;

        char[] binaryData = encoded.toCharArray();
        int lengthDecode = lengthData / 2;
        byte[] decodedData = new byte[lengthDecode];
        byte temp1, temp2;
        char tempChar;
        for( int i = 0; i<lengthDecode; i++ ){
            tempChar = binaryData[i*2];
            temp1 = (tempChar < BASELENGTH) ? hexNumberTable[tempChar] : -1;
            if (temp1 == -1)
                return null;
            tempChar = binaryData[i*2+1];
            temp2 = (tempChar < BASELENGTH) ? hexNumberTable[tempChar] : -1;
            if (temp2 == -1)
                return null;
            decodedData[i] = (byte)((temp1 << 4) | temp2);
        }
        return decodedData;
    }

    /**
     * 判断两个 byte[] 是否相等
     */
    public static Boolean eq(byte[] b1, byte[] b2) {
        if (b1.length != b2.length){
            return false;
        }
        for (int i = 0; i < b1.length; i++) {
            if (b1[i] != b2[i]) return false;
        }
        return true;
    }

    /**
     * 截取片段 - 使用方法与 substring 相同
     * @param data 数据
     * @param start 开始索引
     * @param end 结束索引
     */
    public static byte[] slice(byte[] data, int start, int end) {
        if (start > end){
            return null;
        }
        int len = end - start;
        byte[] buf = new byte[len];
        System.arraycopy(data, start, buf, 0, len);
        return buf;
    }
}
