package cn.valot.common.data;

import java.math.BigDecimal;

public class BigDecimalUtils {
    public static boolean gt(BigDecimal v1, BigDecimal v2){
        return v1.compareTo(v2) > 0;
    }
    public static boolean lt(BigDecimal v1, BigDecimal v2){
        return v1.compareTo(v2) < 0;
    }
    public static boolean eq(BigDecimal v1, BigDecimal v2){
        return v1.compareTo(v2) == 0;
    }
    public static boolean gtEq(BigDecimal v1, BigDecimal v2){
        return v1.compareTo(v2) >= 0;
    }
    public static boolean ltEq(BigDecimal v1, BigDecimal v2){
        return v1.compareTo(v2) <= 0;
    }
    public static boolean negative(BigDecimal v1){
        return lt(v1, BigDecimal.ZERO);
    }
    public static boolean positive(BigDecimal v1){
        return gt(v1, BigDecimal.ZERO);
    }
    public static BigDecimal multi(BigDecimal price, Integer amount) {
        return price.multiply(new BigDecimal(amount));
    }
}
