package cn.valot.common.core;

public class Page {

    /**
     * 页码
     */
    private int pageNum = 1;
    /**
     * 每页数量
     */
    private int pageSize = 10;

    private String sort;

    private Boolean asc = true;

    public Page(int page, int size) {
        this.pageNum = page;
        this.pageSize = size;
    }

    public Page() {
    }

    public void setPageNum(int pageNum) {
        this.pageNum = pageNum;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = Math.max(Math.min(pageSize, 100), 1);
    }

    public int getPageNum() {
        return pageNum;
    }

    public int getPageSize() {
        return pageSize;
    }

    public String getSort() {
        return sort;
    }

    public Boolean getAsc() {
        return asc;
    }
}
