package cn.valot.common;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.support.spring.FastJsonRedisSerializer;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;

@Configuration
@ComponentScan(basePackages = "cn.valot.common")
@Import({ScheduleProperties.class})
public class CommonAutoConfiguration {
    private final ScheduleProperties scheduleProperties;

    public CommonAutoConfiguration(ScheduleProperties scheduleProperties) {
        this.scheduleProperties = scheduleProperties;
    }

    @Bean(name = "valotTreadPoolScheduler")
    public ThreadPoolTaskScheduler threadPoolTaskScheduler(){
        ThreadPoolTaskScheduler pool = new ThreadPoolTaskScheduler();
        pool.setPoolSize(scheduleProperties.getPoolSize());
        pool.setRemoveOnCancelPolicy(scheduleProperties.getRemoveOnCancel());
        pool.setThreadNamePrefix("schedule-valot-prefix");
        return pool;
    }

    @Bean(name = "valotRedisTemplate")
    @ConditionalOnClass(name = {"org.springframework.data.redis.connection.RedisConnectionFactory","com.alibaba.fastjson.JSON"})
    public RedisTemplate<String, Object> redisTemplate(RedisConnectionFactory redisConnectionFactory){
        RedisTemplate<String, Object> template = new RedisTemplate<>();
        template.setConnectionFactory(redisConnectionFactory);
        StringRedisSerializer ks = new StringRedisSerializer();
        RedisSerializer<Object> vs = new FastJsonRedisSerializer<>(Object.class);
        template.setKeySerializer(ks);
        template.setHashKeySerializer(ks);
        template.setValueSerializer(vs);
        template.setHashValueSerializer(vs);
        return template;
    }
}
