/*
 * Decompiled with CFR 0.152.
 */
package cn.univyz.framework.util;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StreamUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(StreamUtil.class);

    public static String getString(InputStream is) {
        StringBuilder sb = new StringBuilder();
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            while ((line = reader.readLine()) != null) {
                sb.append(line);
            }
        }
        catch (Exception e) {
            LOGGER.error("get string failure", (Throwable)e);
            throw new RuntimeException(e);
        }
        return sb.toString();
    }

    public static void copyStream(InputStream inputStream, OutputStream outputStream) {
        try {
            int length;
            byte[] buffer = new byte[4096];
            while ((length = inputStream.read(buffer, 0, buffer.length)) != -1) {
                outputStream.write(buffer, 0, length);
            }
            outputStream.flush();
        }
        catch (Exception e) {
            LOGGER.error("copy stream failure", (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            try {
                inputStream.close();
                outputStream.close();
            }
            catch (Exception e) {
                LOGGER.error("close stream failure", (Throwable)e);
            }
        }
    }
}

