/*
 * Decompiled with CFR 0.152.
 */
package cn.univyz.framework.util;

import cn.univyz.framework.util.ClassUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ReflectionUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReflectionUtil.class);

    public static Object newInstance(Class<?> cls) {
        Object instance;
        try {
            instance = cls.newInstance();
        }
        catch (Exception e) {
            LOGGER.error("new instance failure", (Throwable)e);
            throw new RuntimeException(e);
        }
        return instance;
    }

    public static Object newInstance(String className) {
        Class<?> cls = ClassUtil.loadClass(className);
        return ReflectionUtil.newInstance(cls);
    }

    public static Object invokeMethod(Object obj, Method method, Object ... args) {
        Object result;
        try {
            method.setAccessible(true);
            result = method.invoke(obj, args);
        }
        catch (Exception e) {
            LOGGER.error("invoke method failure", (Throwable)e);
            throw new RuntimeException(e);
        }
        return result;
    }

    public static void setField(Object obj, Field field, Object value) {
        try {
            field.setAccessible(true);
            field.set(obj, value);
        }
        catch (Exception e) {
            LOGGER.error("set field failure", (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

