/*
 * Decompiled with CFR 0.152.
 */
package cn.univyz.framework.util;

import cn.univyz.framework.util.StringUtil;
import java.io.File;
import java.io.FileFilter;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClassUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClassUtil.class);

    public static ClassLoader getClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    public static Class<?> loadClass(String className, boolean isInitialized) {
        Class<?> cls;
        try {
            cls = Class.forName(className, isInitialized, ClassUtil.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            LOGGER.error("load class failure", (Throwable)e);
            throw new RuntimeException(e);
        }
        return cls;
    }

    public static Class<?> loadClass(String className) {
        return ClassUtil.loadClass(className, true);
    }

    public static Set<Class<?>> getClassSet(String packageName) {
        HashSet classesSet = new HashSet();
        try {
            Enumeration<URL> urls = ClassUtil.getClassLoader().getResources(packageName.replace(".", "/"));
            while (urls.hasMoreElements()) {
                JarFile jarFile;
                JarURLConnection jarURLConnection;
                URL url = urls.nextElement();
                if (url == null) continue;
                String protocol = url.getProtocol();
                if (protocol.equals("file")) {
                    String packagePath = url.getPath().replaceAll("%20", "");
                    ClassUtil.addClass(classesSet, packagePath, packageName);
                    continue;
                }
                if (!protocol.equals("jar") || (jarURLConnection = (JarURLConnection)url.openConnection()) == null || (jarFile = jarURLConnection.getJarFile()) == null) continue;
                Enumeration<JarEntry> jarEntries = jarFile.entries();
                while (jarEntries.hasMoreElements()) {
                    JarEntry jarEntry = jarEntries.nextElement();
                    String jarEntryName = jarEntry.getName();
                    if (!jarEntryName.endsWith(".class")) continue;
                    String className = jarEntryName.substring(0, jarEntryName.lastIndexOf(".")).replaceAll("/", ".");
                    ClassUtil.doAddClass(classesSet, className);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("get class set failure", (Throwable)e);
            throw new RuntimeException(e);
        }
        return classesSet;
    }

    private static void addClass(Set<Class<?>> classesSet, String packagePath, String packageName) {
        File[] files;
        for (File file : files = new File(packagePath).listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isFile() && file.getName().endsWith(".class") || file.isDirectory();
            }
        })) {
            String fileName = file.getName();
            if (file.isFile()) {
                String className = fileName.substring(0, fileName.lastIndexOf("."));
                if (StringUtil.isNotEmpty(packageName)) {
                    className = packageName + "." + className;
                }
                ClassUtil.doAddClass(classesSet, className);
                continue;
            }
            String subPackagePath = fileName;
            if (StringUtil.isNotEmpty(packagePath)) {
                subPackagePath = packagePath + "/" + subPackagePath;
            }
            String subPackageName = fileName;
            if (StringUtil.isNotEmpty(packageName)) {
                subPackageName = packageName + "." + subPackageName;
            }
            ClassUtil.addClass(classesSet, subPackagePath, subPackageName);
        }
    }

    private static void doAddClass(Set<Class<?>> classesSet, String className) {
        Class<?> cls = ClassUtil.loadClass(className, false);
        classesSet.add(cls);
    }
}

