/*
 * Decompiled with CFR 0.152.
 */
package cn.univyz.framework.util;

import cn.univyz.framework.util.StringUtil;

public final class CastUtil {
    public static String castString(Object obj) {
        return CastUtil.castString(obj, "");
    }

    public static String castString(Object obj, String defaultValue) {
        return obj != null ? String.valueOf(obj) : defaultValue;
    }

    public static double castDouble(Object obj) {
        return CastUtil.castDouble(obj, 0.0);
    }

    public static double castDouble(Object obj, double defaultValue) {
        String strValue;
        double doubleValue = defaultValue;
        if (obj != null && StringUtil.isNotEmpty(strValue = CastUtil.castString(obj))) {
            try {
                doubleValue = Double.parseDouble(strValue);
            }
            catch (NumberFormatException e) {
                doubleValue = defaultValue;
            }
        }
        return doubleValue;
    }

    public static long castLong(Object obj) {
        return CastUtil.castLong(obj, 0L);
    }

    public static long castLong(Object obj, long defaultValue) {
        String strValue;
        long longValue = defaultValue;
        if (obj != null && StringUtil.isNotEmpty(strValue = CastUtil.castString(obj))) {
            try {
                longValue = Long.parseLong(strValue);
            }
            catch (NumberFormatException e) {
                longValue = defaultValue;
            }
        }
        return longValue;
    }

    public static int castInt(Object obj) {
        return CastUtil.castInt(obj, 0);
    }

    public static int castInt(Object obj, int defaultValue) {
        String strValue;
        int intValue = defaultValue;
        if (obj != null && StringUtil.isNotEmpty(strValue = CastUtil.castString(obj))) {
            try {
                intValue = Integer.parseInt(strValue);
            }
            catch (NumberFormatException e) {
                intValue = defaultValue;
            }
        }
        return intValue;
    }

    public static boolean castBoolean(Object obj) {
        return CastUtil.castBoolean(obj, false);
    }

    public static boolean castBoolean(Object obj, boolean defaultValue) {
        boolean booleanValue = defaultValue;
        if (obj != null) {
            booleanValue = Boolean.parseBoolean(CastUtil.castString(obj));
        }
        return booleanValue;
    }
}

