/*
 * Decompiled with CFR 0.152.
 */
package cn.univyz.framework.proxy;

import cn.univyz.framework.proxy.Proxy;
import cn.univyz.framework.proxy.ProxyChain;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AspectProxy
implements Proxy {
    private static final Logger logger = LoggerFactory.getLogger(AspectProxy.class);

    @Override
    public Object doProxy(ProxyChain proxyChain) throws Throwable {
        Object result = null;
        Class<?> cls = proxyChain.getTargetClass();
        Method method = proxyChain.getTargetMethod();
        Object[] params = proxyChain.getMethodParams();
        this.begin();
        try {
            if (this.intercept(cls, method, params)) {
                this.before(cls, method, params);
                result = proxyChain.doProxyChain();
                this.after(cls, method, params, result);
            } else {
                result = proxyChain.doProxyChain();
            }
        }
        catch (Exception e) {
            logger.error("proxy failure", (Throwable)e);
            this.error(cls, method, params, e);
            throw e;
        }
        finally {
            this.end();
        }
        return result;
    }

    public void begin() {
    }

    public boolean intercept(Class<?> cls, Method method, Object[] params) throws Throwable {
        return true;
    }

    public void before(Class<?> cls, Method method, Object[] params) throws Throwable {
    }

    public void after(Class<?> cls, Method method, Object[] params, Object result) throws Throwable {
    }

    public void error(Class<?> cls, Method method, Object[] params, Throwable e) {
    }

    public void end() {
    }
}

