/*
 * Decompiled with CFR 0.152.
 */
package cn.univyz.framework.helper;

import cn.univyz.framework.bean.FileParam;
import cn.univyz.framework.bean.FormParam;
import cn.univyz.framework.bean.Param;
import cn.univyz.framework.helper.ConfigHelper;
import cn.univyz.framework.util.CollectionUtil;
import cn.univyz.framework.util.FileUtil;
import cn.univyz.framework.util.StreamUtil;
import cn.univyz.framework.util.StringUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UploadHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(UploadHelper.class);
    private static ServletFileUpload servletFileUpload;

    public static void init(ServletContext servletContext) {
        File repository = (File)servletContext.getAttribute("javax.servlet.context.tempdir");
        servletFileUpload = new ServletFileUpload((FileItemFactory)new DiskFileItemFactory(10240, repository));
        int uploadLimit = ConfigHelper.getAppUploadLimit();
        if (uploadLimit != 0) {
            servletFileUpload.setFileSizeMax((long)(uploadLimit * 1024 * 1024));
        }
    }

    public static boolean isMultipart(HttpServletRequest request) {
        return ServletFileUpload.isMultipartContent((HttpServletRequest)request);
    }

    public static Param createParam(HttpServletRequest request) throws IOException {
        ArrayList<FormParam> formParamList = new ArrayList<FormParam>();
        ArrayList<FileParam> fileParamList = new ArrayList<FileParam>();
        try {
            Map fileItemListMap = servletFileUpload.parseParameterMap(request);
            if (CollectionUtil.isNotEmpty(fileItemListMap)) {
                for (Map.Entry fileItemListEntry : fileItemListMap.entrySet()) {
                    String fieldName = (String)fileItemListEntry.getKey();
                    List fileItemList = (List)fileItemListEntry.getValue();
                    if (!CollectionUtil.isNotEmpty(fileItemList)) continue;
                    for (FileItem fileItem : fileItemList) {
                        if (fileItem.isFormField()) {
                            String fieldValue = fileItem.getString("UTF-8");
                            formParamList.add(new FormParam(fieldName, fieldValue));
                            continue;
                        }
                        String fileName = FileUtil.getRealFileName(new String(fileItem.getName().getBytes(), "UTF-8"));
                        if (!StringUtil.isNotEmpty(fileName)) continue;
                        long fileSize = fileItem.getSize();
                        String contentType = fileItem.getContentType();
                        InputStream inputStream = fileItem.getInputStream();
                        fileParamList.add(new FileParam(fieldName, fileName, fileSize, contentType, inputStream));
                    }
                }
            }
        }
        catch (FileUploadException e) {
            LOGGER.error("create param failure", (Throwable)e);
            throw new RuntimeException(e);
        }
        return new Param(formParamList, fileParamList);
    }

    public static void uploadFile(String basePath, FileParam fileParam) {
        try {
            if (fileParam != null) {
                String filePath = basePath + fileParam.getFileName();
                FileUtil.createFile(filePath);
                BufferedInputStream inputStream = new BufferedInputStream(fileParam.getInputStream());
                BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(filePath));
                StreamUtil.copyStream(inputStream, outputStream);
            }
        }
        catch (Exception e) {
            LOGGER.error("upload file failure", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static void uploadFile(String basePath, List<FileParam> fileParamList) {
        try {
            if (CollectionUtil.isNotEmpty(fileParamList)) {
                for (FileParam fileParam : fileParamList) {
                    UploadHelper.uploadFile(basePath, fileParam);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("upload file failure", (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

