/*
 * Decompiled with CFR 0.152.
 */
package cn.univyz.framework.helper;

import java.io.IOException;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ServletHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServletHelper.class);
    private static final ThreadLocal<ServletHelper> SERVLET_HELPER_HOLDER = new ThreadLocal();
    private HttpServletRequest request;
    private HttpServletResponse response;

    private ServletHelper(HttpServletRequest request, HttpServletResponse response) {
        this.request = request;
        this.response = response;
    }

    public static void init(HttpServletRequest request, HttpServletResponse response) {
        SERVLET_HELPER_HOLDER.set(new ServletHelper(request, response));
    }

    public static void destroy() {
        SERVLET_HELPER_HOLDER.remove();
    }

    private static HttpServletRequest getRequest() {
        return ServletHelper.SERVLET_HELPER_HOLDER.get().request;
    }

    private static HttpServletResponse getResponse() {
        return ServletHelper.SERVLET_HELPER_HOLDER.get().response;
    }

    private static HttpSession getSession() {
        return ServletHelper.getRequest().getSession();
    }

    private static ServletContext getServletContext() {
        return ServletHelper.getRequest().getServletContext();
    }

    public static void setRequesAttribut(String key, Object value) {
        ServletHelper.getRequest().setAttribute(key, value);
    }

    public static <T> T getRequestAttribut(String key) {
        return (T)ServletHelper.getRequest().getAttribute(key);
    }

    public static void removeRequestAttribute(String key) {
        ServletHelper.getRequest().removeAttribute(key);
    }

    public static void sendRedirect(String location) {
        try {
            ServletHelper.getResponse().sendRedirect(ServletHelper.getRequest().getContextPath() + location);
        }
        catch (IOException e) {
            LOGGER.error("redirect failure", (Throwable)e);
        }
    }

    public static void setSessionAttribut(String key, Object value) {
        ServletHelper.getSession().setAttribute(key, value);
    }

    public static <T> T getSessionAttribute(String key) {
        return (T)ServletHelper.getRequest().getSession().getAttribute(key);
    }

    public static void removeSessionAttribute(String key) {
        ServletHelper.getRequest().getSession().removeAttribute(key);
    }

    public static void invalidateSession() {
        ServletHelper.getRequest().getSession().invalidate();
    }
}

