/*
 * Decompiled with CFR 0.152.
 */
package cn.univyz.framework.helper;

import cn.univyz.framework.bean.FormParam;
import cn.univyz.framework.bean.Param;
import cn.univyz.framework.util.ArrayUtil;
import cn.univyz.framework.util.CodecUtil;
import cn.univyz.framework.util.StreamUtil;
import cn.univyz.framework.util.StringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.servlet.http.HttpServletRequest;

public final class RequestHelper {
    public static Param createParam(HttpServletRequest request) throws IOException {
        ArrayList<FormParam> formParamList = new ArrayList<FormParam>();
        formParamList.addAll(RequestHelper.parseParameterNames(request));
        formParamList.addAll(RequestHelper.parseInputStream(request));
        return new Param(formParamList);
    }

    private static List<FormParam> parseParameterNames(HttpServletRequest request) {
        ArrayList<FormParam> formParamList = new ArrayList<FormParam>();
        Enumeration paramNames = request.getParameterNames();
        while (paramNames.hasMoreElements()) {
            Object fieldValue;
            String fieldName = (String)paramNames.nextElement();
            Object[] fieldValues = request.getParameterValues(fieldName);
            if (!ArrayUtil.isNotEmpty(fieldValues)) continue;
            if (fieldValues.length == 1) {
                fieldValue = fieldValues[0];
            } else {
                StringBuilder sb = new StringBuilder("");
                for (int i = 0; i < fieldValues.length; ++i) {
                    sb.append((String)fieldValues[i]);
                    if (i == fieldValues.length - 1) continue;
                    sb.append(StringUtil.SEPARATOR);
                }
                fieldValue = sb.toString();
            }
            formParamList.add(new FormParam(fieldName, fieldValue));
        }
        return formParamList;
    }

    private static List<FormParam> parseInputStream(HttpServletRequest request) throws IOException {
        Object[] kvs;
        ArrayList<FormParam> formParamList = new ArrayList<FormParam>();
        String body = CodecUtil.decodeURL(StreamUtil.getString((InputStream)request.getInputStream()));
        if (StringUtil.isNotEmpty(body) && ArrayUtil.isNotEmpty(kvs = StringUtil.splitString(body, "&"))) {
            for (Object kv : kvs) {
                Object[] array = StringUtil.splitString((String)kv, "=");
                if (!ArrayUtil.isNotEmpty(array) || array.length != 2) continue;
                Object fieldName = array[0];
                Object fieldValue = array[1];
                formParamList.add(new FormParam((String)fieldName, fieldValue));
            }
        }
        return formParamList;
    }
}

