/*
 * Decompiled with CFR 0.152.
 */
package cn.univyz.framework.helper;

import cn.univyz.framework.helper.ConfigHelper;
import cn.univyz.framework.util.CollectionUtil;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.ArrayHandler;
import org.apache.commons.dbutils.handlers.ArrayListHandler;
import org.apache.commons.dbutils.handlers.BeanHandler;
import org.apache.commons.dbutils.handlers.BeanListHandler;
import org.apache.commons.dbutils.handlers.ColumnListHandler;
import org.apache.commons.dbutils.handlers.MapHandler;
import org.apache.commons.dbutils.handlers.MapListHandler;
import org.apache.commons.dbutils.handlers.ScalarHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DatabaseHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(DatabaseHelper.class);
    private static final QueryRunner QUERY_RUNNER;
    private static final ThreadLocal<Connection> CONNECTION_HOLDER;
    private static final BasicDataSource DATA_SOURCE;

    public static DataSource getDataSource() {
        return DATA_SOURCE;
    }

    public static Connection getConnection() {
        Connection conn = CONNECTION_HOLDER.get();
        try {
            conn = DATA_SOURCE.getConnection();
        }
        catch (SQLException e) {
            LOGGER.error("get connection failure", (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            CONNECTION_HOLDER.set(conn);
        }
        return conn;
    }

    public static void beginTransaction() {
        Connection conn = DatabaseHelper.getConnection();
        if (conn != null) {
            try {
                conn.setAutoCommit(false);
            }
            catch (SQLException e) {
                LOGGER.error("begin transaction failure", (Throwable)e);
                throw new RuntimeException(e);
            }
            finally {
                CONNECTION_HOLDER.set(conn);
            }
        }
    }

    public static void commitTransaction() {
        Connection conn = DatabaseHelper.getConnection();
        if (conn != null) {
            try {
                conn.commit();
                conn.close();
            }
            catch (SQLException e) {
                LOGGER.error("commit transaction failure", (Throwable)e);
                throw new RuntimeException(e);
            }
            finally {
                CONNECTION_HOLDER.remove();
            }
        }
    }

    public static void rollbackTransaction() {
        Connection conn = DatabaseHelper.getConnection();
        if (conn != null) {
            try {
                conn.rollback();
                conn.close();
            }
            catch (SQLException e) {
                LOGGER.error("rollback transaction failure", (Throwable)e);
                throw new RuntimeException(e);
            }
            finally {
                CONNECTION_HOLDER.remove();
            }
        }
    }

    public static <T> T queryEntity(Class<T> entityClass, String sql, Object ... params) {
        Object entity;
        try {
            Connection conn = DatabaseHelper.getConnection();
            entity = QUERY_RUNNER.query(conn, sql, (ResultSetHandler)new BeanHandler(entityClass), params);
        }
        catch (SQLException e) {
            LOGGER.error("query entity failure", (Throwable)e);
            throw new RuntimeException(e);
        }
        return (T)entity;
    }

    public static <T> List<T> queryEntityList(Class<T> entityClass, String sql, Object ... params) {
        List entityList;
        try {
            Connection conn = DatabaseHelper.getConnection();
            entityList = (List)QUERY_RUNNER.query(conn, sql, (ResultSetHandler)new BeanListHandler(entityClass), params);
        }
        catch (SQLException e) {
            LOGGER.error("query entity list failure", (Throwable)e);
            throw new RuntimeException(e);
        }
        return entityList;
    }

    public static <T> T query(String sql, Object ... params) {
        Object obj;
        try {
            Connection conn = DatabaseHelper.getConnection();
            obj = QUERY_RUNNER.query(conn, sql, (ResultSetHandler)new ScalarHandler(), params);
        }
        catch (SQLException e) {
            LOGGER.error("query failure", (Throwable)e);
            throw new RuntimeException(e);
        }
        return (T)obj;
    }

    public static <T> List<T> queryList(String sql, Object ... params) {
        List list;
        try {
            Connection conn = DatabaseHelper.getConnection();
            list = (List)QUERY_RUNNER.query(conn, sql, (ResultSetHandler)new ColumnListHandler(), params);
        }
        catch (SQLException e) {
            LOGGER.error("query list failure", (Throwable)e);
            throw new RuntimeException(e);
        }
        return list;
    }

    public static <T> Set<T> querySet(String sql, Object ... params) {
        List<T> valueList = DatabaseHelper.queryList(sql, params);
        return new LinkedHashSet<T>(valueList);
    }

    public static Object[] queryArray(String sql, Object ... params) {
        Object[] resultArray;
        try {
            Connection conn = DatabaseHelper.getConnection();
            resultArray = (Object[])QUERY_RUNNER.query(conn, sql, (ResultSetHandler)new ArrayHandler(), params);
        }
        catch (SQLException e) {
            LOGGER.error("query array failure", (Throwable)e);
            throw new RuntimeException(e);
        }
        return resultArray;
    }

    public static List<Object[]> queryArrayList(String sql, Object ... params) {
        List resultArrayList;
        try {
            Connection conn = DatabaseHelper.getConnection();
            resultArrayList = (List)QUERY_RUNNER.query(conn, sql, (ResultSetHandler)new ArrayListHandler(), params);
        }
        catch (SQLException e) {
            LOGGER.error("query array list failure", (Throwable)e);
            throw new RuntimeException(e);
        }
        return resultArrayList;
    }

    public static Map<String, Object> queryMap(String sql, Object ... params) {
        Map resultMap;
        try {
            Connection conn = DatabaseHelper.getConnection();
            resultMap = (Map)QUERY_RUNNER.query(conn, sql, (ResultSetHandler)new MapHandler(), params);
        }
        catch (SQLException e) {
            LOGGER.error("query map failure", (Throwable)e);
            throw new RuntimeException(e);
        }
        return resultMap;
    }

    public static List<Map<String, Object>> queryMapList(String sql, Object ... params) {
        List resultMapList;
        try {
            Connection conn = DatabaseHelper.getConnection();
            resultMapList = (List)QUERY_RUNNER.query(conn, sql, (ResultSetHandler)new MapListHandler(), params);
        }
        catch (SQLException e) {
            LOGGER.error("query map list failure", (Throwable)e);
            throw new RuntimeException(e);
        }
        return resultMapList;
    }

    public static int update(String sql, Object ... params) {
        int rows;
        try {
            Connection conn = DatabaseHelper.getConnection();
            rows = QUERY_RUNNER.update(conn, sql, params);
        }
        catch (SQLException e) {
            LOGGER.error("execute update failure", (Throwable)e);
            throw new RuntimeException(e);
        }
        return rows;
    }

    public static <T> boolean insertEntity(Class<T> entityClass, Map<String, Object> fieldMap) {
        if (CollectionUtil.isEmpty(fieldMap)) {
            LOGGER.error("can not insert entity: fieldMap is empty");
            return false;
        }
        String sql = "INSERT INTO " + DatabaseHelper.getTableName(entityClass);
        StringBuilder columns = new StringBuilder("(");
        StringBuilder values = new StringBuilder("(");
        for (String fieldName : fieldMap.keySet()) {
            columns.append(fieldName).append(", ");
            values.append("?, ");
        }
        columns.replace(columns.lastIndexOf(", "), columns.length(), ")");
        values.replace(values.lastIndexOf(", "), values.length(), ")");
        sql = sql + columns + " VALUES " + values;
        Object[] params = fieldMap.values().toArray();
        return DatabaseHelper.update(sql, params) == 1;
    }

    public static <T> boolean updateEntity(Class<T> entityClass, long id, Map<String, Object> fieldMap) {
        if (CollectionUtil.isEmpty(fieldMap)) {
            LOGGER.error("can not update entity: fieldMap is empty");
            return false;
        }
        String sql = "UPDATE " + DatabaseHelper.getTableName(entityClass) + " SET ";
        StringBuilder columns = new StringBuilder();
        for (String fieldName : fieldMap.keySet()) {
            columns.append(fieldName).append("=?, ");
        }
        sql = sql + columns.substring(0, columns.lastIndexOf(", ")) + " WHERE id=?";
        ArrayList<Object> paramList = new ArrayList<Object>();
        paramList.addAll(fieldMap.values());
        paramList.add(id);
        Object[] params = paramList.toArray();
        return DatabaseHelper.update(sql, params) == 1;
    }

    public static <T> boolean deleteEntity(Class<T> entityClass, long id) {
        String sql = "DELETE FROM " + DatabaseHelper.getTableName(entityClass) + " WHERE id=?";
        return DatabaseHelper.update(sql, id) == 1;
    }

    public static void executeSqlFile(String filePath) {
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(filePath);
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        try {
            String sql;
            while ((sql = reader.readLine()) != null) {
                DatabaseHelper.update(sql, new Object[0]);
            }
        }
        catch (Exception e) {
            LOGGER.error("execute sql file failure", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static String getTableName(Class<?> entityClass) {
        return entityClass.getSimpleName().toLowerCase();
    }

    static {
        CONNECTION_HOLDER = new ThreadLocal();
        QUERY_RUNNER = new QueryRunner();
        DATA_SOURCE = new BasicDataSource();
        DATA_SOURCE.setDriverClassName(ConfigHelper.getJdbcDriver());
        DATA_SOURCE.setUrl(ConfigHelper.getJdbcUrl());
        DATA_SOURCE.setUsername(ConfigHelper.getJdbcUsername());
        DATA_SOURCE.setPassword(ConfigHelper.getJdbcPassword());
    }
}

