/*
 * Decompiled with CFR 0.152.
 */
package cn.univyz.framework.helper;

import cn.univyz.framework.annotation.Action;
import cn.univyz.framework.bean.Handler;
import cn.univyz.framework.bean.Request;
import cn.univyz.framework.helper.ClassHelper;
import cn.univyz.framework.util.ArrayUtil;
import cn.univyz.framework.util.CollectionUtil;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public final class ControllerHelper {
    private static final Map<Request, Handler> ACTION_MAP = new HashMap<Request, Handler>();

    public static Handler getHandler(String requestMethod, String requestPath) {
        Request request = new Request(requestMethod, requestPath);
        return ACTION_MAP.get(request);
    }

    static {
        Set<Class<?>> controllerClassSet = ClassHelper.getControllerClassSet();
        if (CollectionUtil.isNotEmpty(controllerClassSet)) {
            for (Class<?> controllerClass : controllerClassSet) {
                Object[] methosds = controllerClass.getDeclaredMethods();
                if (!ArrayUtil.isNotEmpty(methosds)) continue;
                for (Object method : methosds) {
                    Object[] array;
                    Action action;
                    String mapping;
                    if (!((AccessibleObject)method).isAnnotationPresent(Action.class) || !(mapping = (action = ((Method)method).getAnnotation(Action.class)).value()).matches("\\w+:/\\w*") || !ArrayUtil.isNotEmpty(array = mapping.split(":")) || array.length != 2) continue;
                    Object requestMethod = array[0];
                    Object requestPath = array[1];
                    Request request = new Request((String)requestMethod, (String)requestPath);
                    Handler handler = new Handler(controllerClass, (Method)method);
                    ACTION_MAP.put(request, handler);
                }
            }
        }
    }
}

