/*
 * Decompiled with CFR 0.152.
 */
package cn.univyz.framework.helper;

import cn.univyz.framework.annotation.Controller;
import cn.univyz.framework.annotation.Service;
import cn.univyz.framework.helper.ConfigHelper;
import cn.univyz.framework.util.ClassUtil;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Set;

public final class ClassHelper {
    private static final Set<Class<?>> CLASS_SET;

    public static Set<Class<?>> getClassSet() {
        return CLASS_SET;
    }

    public static Set<Class<?>> getServiceClassSet() {
        HashSet classSet = new HashSet();
        for (Class<?> cls : CLASS_SET) {
            if (!cls.isAnnotationPresent(Service.class)) continue;
            classSet.add(cls);
        }
        return classSet;
    }

    public static Set<Class<?>> getControllerClassSet() {
        HashSet classSet = new HashSet();
        for (Class<?> cls : CLASS_SET) {
            if (!cls.isAnnotationPresent(Controller.class)) continue;
            classSet.add(cls);
        }
        return classSet;
    }

    public static Set<Class<?>> getBeanClassSet() {
        HashSet beanClassSet = new HashSet();
        beanClassSet.addAll(ClassHelper.getServiceClassSet());
        beanClassSet.addAll(ClassHelper.getControllerClassSet());
        return beanClassSet;
    }

    public static Set<Class<?>> getClassSetBySuper(Class<?> superClass) {
        HashSet classSet = new HashSet();
        for (Class<?> cls : CLASS_SET) {
            if (!superClass.isAssignableFrom(cls) || superClass.equals(cls)) continue;
            classSet.add(cls);
        }
        return classSet;
    }

    public static Set<Class<?>> getClassSetByAnnotation(Class<? extends Annotation> annotationClass) {
        HashSet classSet = new HashSet();
        for (Class<?> cls : CLASS_SET) {
            if (!cls.isAnnotationPresent(annotationClass)) continue;
            classSet.add(cls);
        }
        return classSet;
    }

    static {
        String basePackage = ConfigHelper.getAppBasePackage();
        CLASS_SET = ClassUtil.getClassSet(basePackage);
    }
}

