/*
 * Decompiled with CFR 0.152.
 */
package cn.univyz.framework.helper;

import cn.univyz.framework.annotation.Aspect;
import cn.univyz.framework.annotation.Service;
import cn.univyz.framework.helper.BeanHelper;
import cn.univyz.framework.helper.ClassHelper;
import cn.univyz.framework.proxy.AspectProxy;
import cn.univyz.framework.proxy.Proxy;
import cn.univyz.framework.proxy.ProxyManager;
import cn.univyz.framework.proxy.TransactionProxy;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AopHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(AopHelper.class);

    private static Map<Class<?>, Set<Class<?>>> createProxyMap() throws Exception {
        HashMap proxyMap = new HashMap();
        AopHelper.addAspectProxy(proxyMap);
        AopHelper.addTransactionProxy(proxyMap);
        return proxyMap;
    }

    private static void addAspectProxy(Map<Class<?>, Set<Class<?>>> proxyMap) throws Exception {
        Set<Class<?>> proxyClassSet = ClassHelper.getClassSetBySuper(AspectProxy.class);
        for (Class<?> proxyClass : proxyClassSet) {
            if (!proxyClass.isAnnotationPresent(Aspect.class)) continue;
            Aspect aspect = proxyClass.getAnnotation(Aspect.class);
            Set<Class<?>> targetClassSet = AopHelper.createTargetClassSet(aspect);
            proxyMap.put(proxyClass, targetClassSet);
        }
    }

    private static void addTransactionProxy(Map<Class<?>, Set<Class<?>>> proxyMap) {
        Set<Class<?>> serviceClassSet = ClassHelper.getClassSetByAnnotation(Service.class);
        proxyMap.put(TransactionProxy.class, serviceClassSet);
    }

    private static Set<Class<?>> createTargetClassSet(Aspect aspect) throws Exception {
        HashSet targetClassSet = new HashSet();
        Class<? extends Annotation> annotation = aspect.value();
        if (annotation != null && !annotation.equals(Aspect.class)) {
            targetClassSet.addAll(ClassHelper.getClassSetByAnnotation(annotation));
        }
        return targetClassSet;
    }

    private static Map<Class<?>, List<Proxy>> createTargetMap(Map<Class<?>, Set<Class<?>>> proxyMap) throws Exception {
        HashMap targetMap = new HashMap();
        for (Map.Entry<Class<?>, Set<Class<?>>> proxyEntry : proxyMap.entrySet()) {
            Class<?> proxyClass = proxyEntry.getKey();
            Set<Class<?>> targetClassSet = proxyEntry.getValue();
            for (Class<?> targetClass : targetClassSet) {
                Proxy proxy = (Proxy)proxyClass.newInstance();
                if (targetMap.containsKey(targetClass)) {
                    ((List)targetMap.get(targetClass)).add(proxy);
                    continue;
                }
                ArrayList<Proxy> proxyList = new ArrayList<Proxy>();
                proxyList.add(proxy);
                targetMap.put(targetClass, proxyList);
            }
        }
        return targetMap;
    }

    static {
        try {
            Map<Class<?>, Set<Class<?>>> proxyMap = AopHelper.createProxyMap();
            Map<Class<?>, List<Proxy>> targetMap = AopHelper.createTargetMap(proxyMap);
            for (Map.Entry<Class<?>, List<Proxy>> targetEntry : targetMap.entrySet()) {
                Class<?> targetClass = targetEntry.getKey();
                List<Proxy> proxyList = targetEntry.getValue();
                Object proxy = ProxyManager.createProxy(targetClass, proxyList);
                BeanHelper.setBean(targetClass, proxy);
            }
        }
        catch (Exception e) {
            LOGGER.error("aop failure", (Throwable)e);
        }
    }
}

