/*
 * Decompiled with CFR 0.152.
 */
package cn.univyz.framework.bean;

import cn.univyz.framework.bean.FileParam;
import cn.univyz.framework.bean.FormParam;
import cn.univyz.framework.util.CastUtil;
import cn.univyz.framework.util.CollectionUtil;
import cn.univyz.framework.util.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Param {
    private List<FormParam> formParamList;
    private List<FileParam> fileParamList;

    public Param(List<FormParam> formParamList) {
        this.formParamList = formParamList;
    }

    public Param(List<FormParam> formParamList, List<FileParam> fileParamList) {
        this.formParamList = formParamList;
        this.fileParamList = fileParamList;
    }

    public Map<String, Object> getFieldMap() {
        HashMap<String, Object> fieldMap = new HashMap<String, Object>();
        if (CollectionUtil.isNotEmpty(this.formParamList)) {
            for (FormParam formParam : this.formParamList) {
                String fieldName = formParam.getFieldName();
                Object fieldValue = formParam.getFiledValue();
                if (!fieldMap.containsKey(fieldName)) continue;
                fieldValue = fieldMap.get(fieldName) + StringUtil.SEPARATOR + fieldValue;
            }
        }
        return fieldMap;
    }

    public Map<String, List<FileParam>> getFileMap() {
        HashMap<String, List<FileParam>> fileMap = new HashMap<String, List<FileParam>>();
        if (CollectionUtil.isNotEmpty(this.fileParamList)) {
            for (FileParam fileParam : this.fileParamList) {
                String fieldName = fileParam.getFileName();
                List fileParamList = fileMap.containsKey(fieldName) ? (List)fileMap.get(fieldName) : new ArrayList();
                fileParamList.add(fileParam);
                fileMap.put(fieldName, fileParamList);
            }
        }
        return fileMap;
    }

    public List<FileParam> getFileList(String fieldName) {
        return this.getFileMap().get(fieldName);
    }

    public FileParam getFile(String fieldName) {
        List<FileParam> fileParamList = this.getFileList(fieldName);
        if (CollectionUtil.isNotEmpty(fileParamList) && fileParamList.size() == 1) {
            return fileParamList.get(0);
        }
        return null;
    }

    public boolean isEmpty() {
        return CollectionUtil.isEmpty(this.formParamList) && CollectionUtil.isEmpty(this.fileParamList);
    }

    public String getString(String name) {
        return CastUtil.castString(this.getFieldMap().get(name));
    }

    public double getDouble(String name) {
        return CastUtil.castDouble(this.getFieldMap().get(name));
    }

    public long getLong(String name) {
        return CastUtil.castLong(this.getFieldMap().get(name));
    }

    public int getInt(String name) {
        return CastUtil.castInt(this.getFieldMap().get(name));
    }

    public boolean getBoolean(String name) {
        return CastUtil.castBoolean(this.getFieldMap().get(name));
    }
}

