/*
 * Decompiled with CFR 0.152.
 */
package cn.univyz.framework;

import cn.univyz.framework.HelperLoader;
import cn.univyz.framework.bean.Data;
import cn.univyz.framework.bean.Handler;
import cn.univyz.framework.bean.Param;
import cn.univyz.framework.bean.View;
import cn.univyz.framework.helper.BeanHelper;
import cn.univyz.framework.helper.ConfigHelper;
import cn.univyz.framework.helper.ControllerHelper;
import cn.univyz.framework.helper.RequestHelper;
import cn.univyz.framework.helper.ServletHelper;
import cn.univyz.framework.helper.UploadHelper;
import cn.univyz.framework.util.JsonUtil;
import cn.univyz.framework.util.ReflectionUtil;
import cn.univyz.framework.util.StringUtil;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@WebServlet(urlPatterns={"/*"}, loadOnStartup=0)
public class DispatcherServlet
extends HttpServlet {
    public void init(ServletConfig servletConfig) throws ServletException {
        HelperLoader.init();
        ServletContext servletContext = servletConfig.getServletContext();
        ServletRegistration jspServlet = servletContext.getServletRegistration("jsp");
        jspServlet.addMapping(new String[]{ConfigHelper.getAppJspPath() + "*"});
        ServletRegistration defaultServlet = servletContext.getServletRegistration("default");
        defaultServlet.addMapping(new String[]{ConfigHelper.getAppAssetPath() + "*"});
        UploadHelper.init(servletContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ServletHelper.init(request, response);
        try {
            String requestMethod = request.getMethod().toLowerCase();
            String requestPath = request.getPathInfo();
            if (requestPath.equals("/favicon.ico")) {
                return;
            }
            Handler handler = ControllerHelper.getHandler(requestMethod, requestPath);
            if (handler != null) {
                Class<?> controllerClass = handler.getControllerClass();
                Object controllerBean = BeanHelper.getBean(controllerClass);
                Param param = UploadHelper.isMultipart(request) ? UploadHelper.createParam(request) : RequestHelper.createParam(request);
                Method actionMethod = handler.getActionMethod();
                Object result = param.isEmpty() ? ReflectionUtil.invokeMethod(controllerBean, actionMethod, new Object[0]) : ReflectionUtil.invokeMethod(controllerBean, actionMethod, param);
                if (result instanceof View) {
                    this.handleViewResult((View)result, request, response);
                } else if (result instanceof Data) {
                    this.handleDataResult((Data)result, response);
                }
            }
        }
        finally {
            ServletHelper.destroy();
        }
    }

    private void handleViewResult(View view, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String path = view.getPath();
        if (StringUtil.isNotEmpty(path)) {
            if (path.startsWith("/")) {
                response.sendRedirect(request.getContextPath() + path);
            }
        } else {
            Map<String, Object> model = view.getModel();
            for (Map.Entry<String, Object> entry : model.entrySet()) {
                request.setAttribute(entry.getKey(), entry.getValue());
            }
            request.getRequestDispatcher(ConfigHelper.getAppJspPath() + path).forward((ServletRequest)request, (ServletResponse)response);
        }
    }

    private void handleDataResult(Data data, HttpServletResponse response) throws IOException {
        Object model = data.getModel();
        if (model != null) {
            response.setContentType("application/json");
            response.setCharacterEncoding("UTF-8");
            PrintWriter writer = response.getWriter();
            String json = JsonUtil.toJson(model);
            writer.write(json);
            writer.flush();
            writer.close();
        }
    }
}

