/*
 * Decompiled with CFR 0.152.
 */
package cn.tzq0301.spring.websocket;

import cn.tzq0301.retry.Retry;
import com.google.common.base.Preconditions;
import io.micrometer.common.util.StringUtils;
import java.lang.reflect.Type;
import java.time.Duration;
import java.util.concurrent.ExecutionException;
import org.springframework.messaging.converter.MappingJackson2MessageConverter;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.simp.stomp.StompCommand;
import org.springframework.messaging.simp.stomp.StompHeaders;
import org.springframework.messaging.simp.stomp.StompSession;
import org.springframework.messaging.simp.stomp.StompSessionHandler;
import org.springframework.web.socket.client.WebSocketClient;
import org.springframework.web.socket.client.standard.StandardWebSocketClient;
import org.springframework.web.socket.messaging.WebSocketStompClient;

public interface StompSessionHandlerAdaptor
extends StompSessionHandler {
    default public boolean connect(String serverAddr) throws ExecutionException, InterruptedException {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)serverAddr));
        StandardWebSocketClient client = new StandardWebSocketClient();
        WebSocketStompClient stompClient = new WebSocketStompClient((WebSocketClient)client);
        stompClient.setMessageConverter((MessageConverter)new MappingJackson2MessageConverter());
        StompSession stompSession = (StompSession)stompClient.connectAsync(serverAddr, (StompSessionHandler)this, new Object[0]).get();
        return stompSession.isConnected();
    }

    default public boolean tryConnect(String serverAddr) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)serverAddr));
        try {
            return this.connect(serverAddr);
        }
        catch (InterruptedException | ExecutionException ignored) {
            return false;
        }
    }

    default public void retryConnect(String serverAddr) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)serverAddr));
        Retry.of(epoch -> this.tryConnect(serverAddr), Integer.MAX_VALUE, Duration.ofSeconds(2L), true, true);
    }

    default public void afterConnected(StompSession session, StompHeaders connectedHeaders) {
    }

    default public void handleException(StompSession session, StompCommand command, StompHeaders headers, byte[] payload, Throwable exception) {
    }

    default public void handleTransportError(StompSession session, Throwable exception) {
    }

    default public Type getPayloadType(StompHeaders headers) {
        return String.class;
    }

    default public void handleFrame(StompHeaders headers, Object payload) {
    }
}

