/*
 * Decompiled with CFR 0.152.
 */
package cn.tzq0301.retry;

import java.time.Duration;
import java.util.Random;
import java.util.function.Function;

public final class Retry {
    private Retry() {
    }

    public static void of(Function<Integer, Boolean> task, int times, Duration interval) {
        Retry.of(task, times, interval, false, false);
    }

    public static void of(Function<Integer, Boolean> task, int times, Duration interval, boolean useExponentialBackoff) {
        Retry.of(task, times, interval, useExponentialBackoff, false);
    }

    public static void of(Function<Integer, Boolean> task, int times, Duration interval, boolean useExponentialBackoff, boolean useJitter) {
        int epoch = 1;
        while (times > 0) {
            try {
                boolean result = task.apply(epoch);
                if (result) {
                    return;
                }
            }
            catch (Throwable result) {
                // empty catch block
            }
            long sleepDuration = interval.toMillis();
            if (useExponentialBackoff) {
                sleepDuration *= (long)Math.pow(2.0, epoch - 1);
            }
            if (useJitter) {
                Random random = new Random();
                long jitter = random.nextLong(interval.toMillis());
                sleepDuration = random.nextBoolean() ? (sleepDuration += jitter) : (sleepDuration -= jitter);
            }
            Thread.sleep(sleepDuration);
            ++epoch;
            --times;
        }
    }
}

