/*
 * Decompiled with CFR 0.152.
 */
package cn.tzq0301.http.rest.result;

import cn.tzq0301.http.rest.result.ResultCodeEnum;
import com.google.common.base.Preconditions;
import io.micrometer.common.util.StringUtils;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public record Result<T>(@NonNull String code, @NonNull String message, @Nullable T data) {
    public Result(@NonNull String code, @NonNull String message, @Nullable T data) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)code));
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)message));
    }

    public static Result<?> success() {
        return new Result<Object>(ResultCodeEnum.SUCCESS.getCode(), ResultCodeEnum.SUCCESS.getMessage(), null);
    }

    public static <T> Result<T> success(@Nullable T data) {
        return new Result<T>(ResultCodeEnum.SUCCESS.getCode(), ResultCodeEnum.SUCCESS.getMessage(), data);
    }

    public static Result<?> error(ResultCodeEnum resultCodeEnum) {
        return new Result<Object>(resultCodeEnum.getCode(), resultCodeEnum.getMessage(), null);
    }

    public static Result<?> error(ResultCodeEnum resultCodeEnum, String message) {
        return new Result<Object>(resultCodeEnum.getCode(), message, null);
    }

    public static <T> Result<T> error(ResultCodeEnum resultCodeEnum, T data) {
        return new Result<T>(resultCodeEnum.getCode(), resultCodeEnum.getMessage(), data);
    }

    public static <T> Result<T> error(ResultCodeEnum resultCodeEnum, String message, T data) {
        return new Result<T>(resultCodeEnum.getCode(), message, data);
    }
}

