package cn.tzq0301.http.rest.result;

import io.micrometer.common.util.StringUtils;

import static com.google.common.base.Preconditions.checkArgument;

public enum ResultCodeEnum {
    SUCCESS("00000", "OK"), // 正确执行后的返回
    USER_ERROR("A0001", "用户端错误"), // 一级宏观错误码
    USER_REGISTER_ERROR("A0100", "用户注册错误"), // 二级宏观错误码
    USER_REGISTER_DONT_AGREE_PRIVACY_AGREEMENT("A0101", "用户未同意隐私协议"),
    USER_REGISTER_COUNTRY_OR_REGION_OF_REGISTRATION_RESTRICTED("A0102", "注册国家或地区受限"),
    USER_REGISTER_USERNAME_INVALID("A0110", "用户名校验失败"),
    USER_REGISTER_USERNAME_ALREADY_EXISTS("A0111", "用户名已存在"),
    USER_REGISTER_USERNAME_CONTAINS_SENSITIVE_WORDS("A0112", "用户名包含敏感词"),
    USER_REGISTER_USERNAME_CONTAINS_SPECIAL_CHARACTERS("A0113", "用户名包含特殊字符"),
    USER_REGISTER_PASSWORD_INVALID("A0120", "密码校验失败"),
    USER_REGISTER_PASSWORD_TOO_SHORT("A0121", "密码长度不够"),
    USER_REGISTER_PASSWORD_NOT_STRONG_ENOUGH("A0122", "密码强度不够"),
    USER_REGISTER_TOKEN_ERROR("A0130", "校验码输入错误"),
    USER_REGISTER_SMS_TOKEN_ERROR("A0131", "短信校验码输入错误"),
    USER_REGISTER_EMAIL_TOKEN_ERROR("A0132", "邮件校验码输入错误"),
    USER_REGISTER_VOICE_TOKEN_ERROR("A0133", "语音校验码输入错误"),
    USER_REGISTER_CREDENTIAL_ABNORMAL("A0140", "用户证件异常"),
    USER_REGISTER_CREDENTIAL_TYPE_NOT_SELECT("A0141", "用户证件类型未选择"),
    USER_REGISTER_ILLEGAL_MAINLAND_ID_NUMBER_VERIFICATION("A0142", "大陆身份证编号校验非法"),
    USER_REGISTER_ILLEGAL_PASSPORT_NUMBER_VERIFICATION("A0143", "护照编号校验非法"),
    USER_REGISTER_ILLEGAL_MILITARY_ID_NUMBER("A0144", "军官证编号校验非法"),
    USER_REGISTER_INVALID_BASIC_INFORMATION("A0150", "用户基本信息校验失败"),
    USER_REGISTER_INVALID_PHONE_NUMBER("A0151", "手机格式校验失败"),
    USER_REGISTER_INVALID_ADDRESS("A0152", "地址格式校验失败"),
    USER_REGISTER_INVALID_EMAIL("A0153", "邮箱格式校验失败"),
    USER_LOGIN_ERROR("A0200", "用户登录异常"), // 二级宏观错误码
    USER_LOGIN_ACCOUNT_NOT_EXIST("A0201", "用户账户不存在"),
    USER_LOGIN_ACCOUNT_FROZEN("A0202", "用户账户被冻结"),
    USER_LOGIN_ACCOUNT_INVALIDATED("A0203", "用户账户已作废"),
    USER_LOGIN_INCORRECT_PASSWORD("A0210", "用户密码错误"),
    USER_LOGIN_RETRY_TIMES_EXCEED_LIMIT("A0211", "用户输入密码错误次数超限"),
    USER_LOGIN_INVALID_IDENTITY_VERIFICATION("A0220", "用户身份校验失败"),
    USER_LOGIN_INVALID_FINGERPRINT_VERIFICATION("A0221", "用户指纹校验失败"),
    USER_LOGIN_INVALID_FACE_VERIFICATION("A0222", "用户面容校验失败"),
    USER_LOGIN_NOT_AUTHORIZED_BY_THIRD_PARTY("A0223", "用户未获得第三方登录授权"),
    USER_LOGIN_TOKEN_EXPIRED("A0230", "用户登录已过期"),
    USER_LOGIN_VALIDATION_CODE_ERROR("A0240", "用户验证码错误"),
    USER_LOGIN_VALIDATION_CODE_RETRY_TIME_EXCEED_LIMIT("A0241", "用户验证码尝试次数超限"),
    USER_PERMISSION_ERROR("A0300", "访问权限异常"), // 二级宏观错误码
    USER_PERMISSION_UNAUTHORIZED("A0301", "访问未授权"),
    USER_PERMISSION_AUTHORIZING("A0302", "正在授权中"),
    USER_PERMISSION_AUTHORIZATION_REJECTED("A0303", "用户授权申请被拒绝"),
    USER_PERMISSION_BLOCKED_BY_OBJECT_PRIVACY_SETTINGS("A0310", "因访问对象隐私设置被拦截"),
    USER_PERMISSION_AUTHORIZATION_EXPIRED("A0311", "授权已过期"),
    USER_PERMISSION_NO_AUTHORIZATION_OF_API("A0312", "无权限使用 API"),
    USER_PERMISSION_ACCESS_BLOCKED("A0320", "用户访问被拦截"),
    USER_PERMISSION_BLACK_LIST_USER("A0321", "黑名单用户"),
    USER_PERMISSION_FROZEN_ACCOUNT("A0322", "账号被冻结"),
    USER_PERMISSION_ILLEGAL_IP_ADDRESS("A0323", "非法 IP 地址"),
    USER_PERMISSION_GATEWAY_ACCESS_RESTRICTED("A0324", "网关访问受限"),
    USER_PERMISSION_BLACK_LIST_AREA("A0325", "地域黑名单"),
    USER_PERMISSION_SERVICE_IN_ARREARS("A0330", "服务已欠费"),
    USER_PERMISSION_SIGNATURE_ERROR("A0340", "用户签名异常"),
    USER_PERMISSION_RSA_SIGNATURE_ERROR("A0341", "RSA 签名错误"),
    USER_REQUEST_PARAM_ERROR("A0400", "用户请求参数错误"), // 二级宏观错误码
    USER_REQUEST_PARAM_CONTAINS_ILLEGAL_LINK("A0401", "包含非法恶意跳转链接"),
    USER_REQUEST_PARAM_INVALID_INPUT("A0402", "无效的用户输入"),
    USER_REQUEST_PARAM_EMPTY_REQUIRED_PARAM("A0410", "请求必填参数为空"),
    USER_REQUEST_PARAM_EMPTY_ORDER_ID("A0411", "用户订单号为空"),
    USER_REQUEST_PARAM_EMPTY_ORDER_QUANTITY("A0412", "订购数量为空"),
    USER_REQUEST_PARAM_EMPTY_TIMESTAMP("A0413", "缺少时间戳参数"),
    USER_REQUEST_PARAM_ILLEGAL_TIMESTAMP("A0414", "非法的时间戳参数"),
    USER_REQUEST_PARAM_EXCEED_LIMIT("A0420", "请求参数值超出允许的范围"),
    USER_REQUEST_PARAM_FORMAT_NOT_MATCH("A0421", "参数格式不匹配"),
    USER_REQUEST_PARAM_ADDRESS_NOT_IN_RANGE("A0422", "地址不在服务范围"),
    USER_REQUEST_PARAM_TIME_NOT_IN_RANGE("A0423", "时间不在服务范围"),
    USER_REQUEST_PARAM_AMOUNT_EXCEED_LIMIT("A0424", "金额超出限制"),
    USER_REQUEST_PARAM_QUANTITY_EXCEED_LIMIT("A0425", "数量超出限制"),
    USER_REQUEST_PARAM_NUM_OF_BATCH_EXCEED_LIMIT("A0426", "请求批量处理总个数超出限制"),
    USER_REQUEST_PARAM_JSON_PARSE_ERROR("A0427", "请求 JSON 解析失败"),
    USER_REQUEST_PARAM_ILLEGAL_INPUT("A0430", "用户输入内容非法"),
    USER_REQUEST_PARAM_CONTAINS_SENSITIVE_WORDS("A0431", "包含违禁敏感词"),
    USER_REQUEST_PARAM_IMAGE_CONTAINS_ILLEGAL_INFORMATION("A0432", "图片包含违禁信息"),
    USER_REQUEST_PARAM_FILE_INFRINGE_COPYRIGHT("A0433", "文件侵犯版权"),
    USER_REQUEST_PARAM_OPERATION_ERROR("A0440", "用户操作异常"),
    USER_REQUEST_PARAM_PAYMENT_TIMEOUT("A0441", "用户支付超时"),
    USER_REQUEST_PARAM_CONFIRM_ORDER_TIMEOUT("A0442", "确认订单超时"),
    USER_REQUEST_PARAM_ORDER_CLOSED("A0443", "订单已关闭"),
    USER_REQUEST_SERVICE_ERROR("A0500", "用户请求服务异常"), // 二级宏观错误码
    USER_REQUEST_SERVICE_REQUEST_NUM_EXCEED_LIMIT("A0501", "请求次数超出限制"),
    USER_REQUEST_SERVICE_REQUEST_CONCURRENT_NUM_EXCEED_LIMIT("A0502", "请求并发数超出限制"),
    USER_REQUEST_SERVICE_PLEASE_WAIT("A0503", "用户操作请等待"),
    USER_REQUEST_SERVICE_WEBSOCKET_CONNECTION_ERROR("A0504", "WebSocket 连接异常"),
    USER_REQUEST_SERVICE_WEBSOCKET_DISCONNECTED("A0505", "WebSocket 连接断开"),
    USER_REQUEST_SERVICE_DUPLICATED_REQUEST("A0506", "用户重复请求"),
    USER_RESOURCE_ERROR("A0600", "用户资源异常"), // 二级宏观错误码
    USER_RESOURCE_ACCOUNT_NOT_ENOUGH("A0601", "账户余额不足"),
    USER_RESOURCE_DISK_SPACE_NOT_ENOUGH("A0602", "用户磁盘空间不足"),
    USER_RESOURCE_MEMORY_NOT_ENOUGH("A0603", "用户内存空间不足"),
    USER_RESOURCE_OSS_NOT_ENOUGH("A0604", "用户 OSS 容量不足"),
    USER_RESOURCE_EMPTY_QUOTA("A0605", "用户配额已用光"),
    USER_UPLOAD_ERROR("A0700", "用户上传文件异常"),
    USER_UPLOAD_TYPE_NOT_MATCH("A0701", "用户上传文件类型不匹配"),
    USER_UPLOAD_FILE_TOO_LARGE("A0702", "用户上传文件太大"),
    USER_UPLOAD_IMAGE_TOO_LARGE("A0703", "用户上传图片太大"),
    USER_UPLOAD_VIDEO_TOO_LARGE("A0704", "用户上传视频太大"),
    USER_UPLOAD_COMPRESSED_FILE_TOO_LARGE("A0705", "用户上传压缩文件太大"),
    USER_VERSION_ERROR("A0800", "用户当前版本异常"), // 二级宏观异常码
    USER_VERSION_NOT_MATCH_WITH_SYSTEM("A0801", "用户安装版本与系统不匹配"),
    USER_VERSION_TOO_LOW("A0802", "用户安装版本过低"),
    USER_VERSION_TOO_HIGH("A0803", "用户安装版本过高"),
    USER_VERSION_EXPIRED("A0804", "用户安装版本已过期"),
    USER_VERSION_API_REQUEST_VERSION_NOT_MATCH("A0805", "用户 API 请求版本不匹配"),
    USER_VERSION_API_REQUEST_VERSION_TOO_HIGH("A0806", "用户 API 请求版本过高"),
    USER_VERSION_API_REQUEST_VERSION_TOO_LOW("A0807", "用户 API 请求版本过低"),
    USER_PRIVACY_ERROR("A0900", "用户隐私未授权"),
    USER_PRIVACY_UNSIGNED("A0901", "用户隐私未签署"),
    USER_PRIVACY_WEBCAM_UNAUTHORIZED("A0902", "用户摄像头未授权"),
    USER_PRIVACY_CAMERA_UNAUTHORIZED("A0903", "用户相机未授权"),
    USER_PRIVACY_GALLERY_UNAUTHORIZED("A0904", "用户图片库未授权"),
    USER_PRIVACY_FILE_UNAUTHORIZED("A0905", "用户文件未授权"),
    USER_PRIVACY_POSITION_UNAUTHORIZED("A0906", "用户位置信息未授权"),
    USER_PRIVACY_CONTACT_UNAUTHORIZED("A0907", "用户通讯录未授权"),
    USER_EQUIPMENT_ERROR("A1000", "用户设备异常"),
    USER_EQUIPMENT_CAMERA_ERROR("A1001", "用户相机异常"),
    USER_EQUIPMENT_MIC_ERROR("A1002", "用户麦克风异常"),
    USER_EQUIPMENT_EARPIECE_ERROR("A1003", "用户听筒异常"),
    USER_EQUIPMENT_LOUDSPEAKER_ERROR("A1004", "用户扬声器异常"),
    USER_EQUIPMENT_GPS_ERROR("A1005", "用户 GPS 定位异常"),
    SYSTEM_ERROR("B0001", "系统执行出错"), // 一级宏观错误码
    SYSTEM_EXECUTE_TIMEOUT("B0100", "系统执行超时"), // 二级宏观错误码
    SYSTEM_EXECUTE_ORDER_TIMEOUT("B0101", "系统订单处理超时"),
    SYSTEM_DISASTER_RECOVERY("B0200", "系统容灾功能被触发"), // 二级宏观错误码
    SYSTEM_DISASTER_RECOVERY_LIMIT_RATE("B0210", "系统限流"),
    SYSTEM_DISASTER_RECOVERY_FUNCTIONALITY_DEGRADE("B0220", "系统功能降级"),
    SYSTEM_RESOURCE_ERROR("B0300", "系统资源异常"), // 二级宏观错误码
    SYSTEM_RESOURCE_EMPTY("B0310", "系统资源耗尽"),
    SYSTEM_RESOURCE_EMPTY_DISK_SPACE("B0311", "系统磁盘空间耗尽"),
    SYSTEM_RESOURCE_EMPTY_MEMORY("B0312", "系统内存耗尽"),
    SYSTEM_RESOURCE_EMPTY_FILE_HANDLER("B0313", "文件句柄耗尽"),
    SYSTEM_RESOURCE_EMPTY_CONNECTION_POOL("B0314", "系统连接池耗尽"),
    SYSTEM_RESOURCE_EMPTY_THREAD_POOL("B0315", "系统线程池耗尽"),
    SYSTEM_RESOURCE_ACCESS_ERROR("B0320", "系统资源访问异常"),
    SYSTEM_RESOURCE_READ_DISK_FILE_ERROR("B0321", "系统读取磁盘文件失败"),
    CLIENT_ERROR("C0001", "调用第三方服务出错"), // 一级宏观错误码
    CLIENT_MIDDLEWARE_ERROR("C0100", "中间件服务出错"), // 二级宏观错误码
    CLIENT_MIDDLEWARE_RPC_ERROR("C0110", "RPC 服务出错"),
    CLIENT_MIDDLEWARE_RPC_NOT_FOUND("C0111", "RPC 服务未找到"),
    CLIENT_MIDDLEWARE_RPC_NOT_REGISTERED("C0112", "RPC 服务未注册"),
    CLIENT_MIDDLEWARE_RPC_INTERFACE_NOT_EXIST("C0113", "RPC 接口不存在"),
    CLIENT_MIDDLEWARE_MESSAGE_ERROR("C0120", "消息服务出错"),
    CLIENT_MIDDLEWARE_MESSAGE_PROVIDE_ERROR("C0121", "消息投递出错"),
    CLIENT_MIDDLEWARE_MESSAGE_CONSUME_ERROR("C0122", "消息消费出错"),
    CLIENT_MIDDLEWARE_MESSAGE_SUBSCRIBE_ERROR("C0123", "消息订阅出错"),
    CLIENT_MIDDLEWARE_MESSAGE_GROUP_NOT_FOUND("C0124", "消息分组未查到"),
    CLIENT_MIDDLEWARE_CACHE_ERROR("C0130", "缓存服务出错"),
    CLIENT_MIDDLEWARE_CACHE_LENGTH_OF_KEY_EXCEED_LIMIT("C0131", "key 长度超过限制"),
    CLIENT_MIDDLEWARE_CACHE_LENGTH_OF_VALUE_EXCEED_LIMIT("C0132", "value 长度超过限制"),
    CLIENT_MIDDLEWARE_CACHE_STORAGE_FULL("C0133", "存储容量已满"),
    CLIENT_MIDDLEWARE_CACHE_UNSUPPORTED_FORMAT("C0134", "不支持的数据格式"),
    CLIENT_MIDDLEWARE_CONFIG_ERROR("C0140", "配置服务出错"),
    CLIENT_MIDDLEWARE_NETWORK_ERROR("C0150", "网络资源服务出错"),
    CLIENT_MIDDLEWARE_NETWORK_VPN_ERROR("C0151", "VPN 服务出错"),
    CLIENT_MIDDLEWARE_NETWORK_CDN_ERROR("C0152", "CDN 服务出错"),
    CLIENT_MIDDLEWARE_NETWORK_DOMAIN_RESOLVE_ERROR("C0153", "域名解析服务出错"),
    CLIENT_MIDDLEWARE_NETWORK_GATEWAY_ERROR("C0154", "网关服务出错"),
    CLIENT_TIMEOUT_ERROR("C0200", "第三方系统执行超时"), // 二级宏观错误码
    CLIENT_TIMEOUT_RPC("C0210", "RPC 执行超时"),
    CLIENT_TIMEOUT_MESSAGE_PROVIDE("C0220", "消息投递超时"),
    CLIENT_TIMEOUT_CACHE("C0230", "缓存服务超时"),
    CLIENT_TIMEOUT_DATABASE("C0240", "数据库服务超时"),
    CLIENT_DATABASE_ERROR("C0300", "数据库服务出错"),
    CLIENT_DATABASE_TABLE_NOT_EXIST("C0311", "表不存在"),
    CLIENT_DATABASE_COLUMN_NOT_EXIST("C0312", "列不存在"),
    CLIENT_DATABASE_MULTI_SAME_COLUMNS_WHILE_JOINING("C0321", "多表关联中存在多个相同名称的列"),
    CLIENT_DATABASE_DEAD_LOCK("C0331", "数据库死锁"),
    CLIENT_DATABASE_PRIMARY_KEY_CONFLICT("C0341", "主键冲突"),
    CLIENT_DISASTER_RECOVERY("C0400", "第三方容灾功能被触发"), // 二级宏观错误码
    CLIENT_DISASTER_RECOVERY_LIMIT_RATE("C0401", "第三方服务限流"),
    CLIENT_DISASTER_RECOVERY_FUNCTIONALITY_DEGRADE("C0402", "第三方功能降级"),
    CLIENT_NOTIFY_ERROR("C0500", "通知服务出错"), // 二级宏观错误码
    CLIENT_NOTIFY_SMS_ERROR("C0501", "短信提醒服务失败"),
    CLIENT_NOTIFY_VOICE_ERROR("C0502", "语音提醒服务失败"),
    CLIENT_NOTIFY_EMAIL_ERROR("C0503", "邮件提醒服务失败"),
    ;

    private final String code;
    private final String message;

    ResultCodeEnum(String code, String message) {
        checkArgument(StringUtils.isNotBlank(code));
        checkArgument(StringUtils.isNotBlank(message));
        this.code = code;
        this.message = message;
    }

    public String getCode() {
        return code;
    }

    public String getMessage() {
        return message;
    }
}
