/*
 * Decompiled with CFR 0.152.
 */
package com.joolun.cloud.common.storage.util;

import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.joolun.cloud.common.storage.entity.StorageConfig;
import com.qiniu.common.QiniuException;
import com.qiniu.http.Response;
import com.qiniu.storage.Configuration;
import com.qiniu.storage.Region;
import com.qiniu.storage.UploadManager;
import com.qiniu.storage.model.DefaultPutRet;
import com.qiniu.util.Auth;
import java.io.File;
import java.util.UUID;
import org.apache.commons.lang.RandomStringUtils;

public class QiNiuUtils {
    private final StorageConfig storageConfig;

    public String uploadFile(File file, String dir) throws QiniuException {
        Configuration cfg = new Configuration(Region.autoRegion());
        UploadManager uploadManager = new UploadManager(cfg);
        String accessKey = this.storageConfig.getAccessKeyId();
        String secretKey = this.storageConfig.getAccessKeySecret();
        String bucket = this.storageConfig.getBucket();
        String fileName = file.getName();
        String suffix = fileName.substring(fileName.lastIndexOf(".") + 1);
        String key = this.preHandle(UUID.randomUUID() + "." + suffix, dir);
        Auth auth = Auth.create((String)accessKey, (String)secretKey);
        String upToken = auth.uploadToken(bucket);
        Response response = uploadManager.put(file, key, upToken);
        String resultStr = this.getUrlPath(response);
        return resultStr;
    }

    private String preHandle(String fileName, String dir) {
        String name;
        if (StrUtil.isNotBlank((CharSequence)dir) && !dir.startsWith("/")) {
            dir = "/" + dir;
        }
        String string = name = StrUtil.isBlank((CharSequence)fileName) ? RandomStringUtils.randomAlphanumeric((int)32) : fileName;
        if (StrUtil.isBlank((CharSequence)dir)) {
            return name;
        }
        String prefix = dir.replaceFirst("/", "");
        return (prefix.endsWith("/") ? prefix : prefix.concat("/")).concat(name);
    }

    private String getUrlPath(Response response) throws QiniuException {
        DefaultPutRet putRet = (DefaultPutRet)JSONUtil.toBean((String)response.bodyString(), DefaultPutRet.class);
        String key = putRet.key;
        return "http://" + this.storageConfig.getEndpoint() + (key.startsWith("/") ? key : "/" + key);
    }

    public QiNiuUtils(StorageConfig storageConfig) {
        this.storageConfig = storageConfig;
    }
}

