/*
 * Decompiled with CFR 0.152.
 */
package com.joolun.cloud.common.storage.util;

import com.joolun.cloud.common.storage.entity.StorageConfig;
import com.qcloud.cos.COSClient;
import com.qcloud.cos.ClientConfig;
import com.qcloud.cos.auth.BasicCOSCredentials;
import com.qcloud.cos.auth.COSCredentials;
import com.qcloud.cos.model.PutObjectRequest;
import com.qcloud.cos.region.Region;
import java.io.File;
import java.net.URL;
import java.util.Date;
import java.util.UUID;

public class QcloudCosUtils {
    private final StorageConfig storageConfig;

    public String uploadFile(File file, String dir) {
        String secretId = this.storageConfig.getAccessKeyId();
        String secretKey = this.storageConfig.getAccessKeySecret();
        BasicCOSCredentials cred = new BasicCOSCredentials(secretId, secretKey);
        Region region = new Region(this.storageConfig.getEndpoint());
        ClientConfig clientConfig = new ClientConfig(region);
        COSClient cosClient = new COSClient((COSCredentials)cred, clientConfig);
        String bucketName = this.storageConfig.getBucket();
        String fileName = file.getName();
        String suffix = fileName.substring(fileName.lastIndexOf(".") + 1);
        String key = dir + UUID.randomUUID() + "." + suffix;
        PutObjectRequest putObjectRequest = new PutObjectRequest(bucketName, key, file);
        cosClient.putObject(putObjectRequest);
        cosClient.shutdown();
        Date expiration = new Date(new Date().getTime() + 3000000L);
        URL url = cosClient.generatePresignedUrl(bucketName, key, expiration);
        String resultStr = "https://" + url.getHost() + "/" + key;
        return resultStr;
    }

    public QcloudCosUtils(StorageConfig storageConfig) {
        this.storageConfig = storageConfig;
    }
}

