/*
 * Decompiled with CFR 0.152.
 */
package com.joolun.cloud.common.storage.util;

import com.joolun.cloud.common.storage.entity.StorageConfig;
import io.minio.MinioClient;
import io.minio.errors.ErrorResponseException;
import io.minio.errors.InsufficientDataException;
import io.minio.errors.InternalException;
import io.minio.errors.InvalidArgumentException;
import io.minio.errors.InvalidBucketNameException;
import io.minio.errors.InvalidEndpointException;
import io.minio.errors.InvalidPortException;
import io.minio.errors.NoResponseException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.UUID;
import javax.activation.MimetypesFileTypeMap;
import org.xmlpull.v1.XmlPullParserException;

public class MinioUtils {
    private final StorageConfig storageConfig;

    public String uploadFile(File file, String dir) throws InvalidPortException, InvalidEndpointException, IOException, InvalidKeyException, NoSuchAlgorithmException, InsufficientDataException, InternalException, NoResponseException, InvalidBucketNameException, XmlPullParserException, ErrorResponseException, InvalidArgumentException {
        MinioClient minioClient = new MinioClient(this.storageConfig.getEndpoint(), this.storageConfig.getAccessKeyId(), this.storageConfig.getAccessKeySecret());
        String fileName = file.getName();
        String suffix = fileName.substring(fileName.lastIndexOf(".") + 1);
        String key = dir + UUID.randomUUID() + "." + suffix;
        minioClient.putObject(this.storageConfig.getBucket(), key, (InputStream)new FileInputStream(file), Long.valueOf(file.length()), null, null, new MimetypesFileTypeMap().getContentType(file));
        String resultStr = minioClient.getObjectUrl(this.storageConfig.getBucket(), key);
        return resultStr;
    }

    public MinioUtils(StorageConfig storageConfig) {
        this.storageConfig = storageConfig;
    }
}

