/*
 * Decompiled with CFR 0.152.
 */
package com.joolun.cloud.common.storage.util;

import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSClientBuilder;
import com.aliyun.oss.model.PutObjectRequest;
import com.joolun.cloud.common.storage.entity.StorageConfig;
import java.io.File;
import java.util.UUID;

public class AliOssUtils {
    private final StorageConfig storageConfig;

    public String uploadFile(File file, String dir) {
        OSS ossClient = new OSSClientBuilder().build(this.storageConfig.getEndpoint(), this.storageConfig.getAccessKeyId(), this.storageConfig.getAccessKeySecret());
        String fileName = file.getName();
        String suffix = fileName.substring(fileName.lastIndexOf(".") + 1);
        String key = dir + UUID.randomUUID() + "." + suffix;
        PutObjectRequest putObjectRequest = new PutObjectRequest(this.storageConfig.getBucket(), key, file);
        ossClient.putObject(putObjectRequest);
        ossClient.shutdown();
        String resultStr = "https://" + this.storageConfig.getBucket() + "." + this.storageConfig.getEndpoint() + "/" + key;
        return resultStr;
    }

    public AliOssUtils(StorageConfig storageConfig) {
        this.storageConfig = storageConfig;
    }
}

