/*
 * Decompiled with CFR 0.152.
 */
package com.joolun.cloud.common.sms.util;

import com.aliyuncs.CommonRequest;
import com.aliyuncs.CommonResponse;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.http.MethodType;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import com.joolun.cloud.common.sms.config.SmsConfigProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;

@Configuration
public class SmsUtils {
    private static final Logger log = LoggerFactory.getLogger(SmsUtils.class);
    private final SmsConfigProperties smsConfigProperties;

    public void sendSms(String signName, String phoneNumbers, String templateCode, String templateParam) throws ClientException {
        DefaultProfile profile = DefaultProfile.getProfile((String)this.smsConfigProperties.getRegionId(), (String)this.smsConfigProperties.getAccessKeyId(), (String)this.smsConfigProperties.getAccessKeySecret());
        DefaultAcsClient client = new DefaultAcsClient((IClientProfile)profile);
        CommonRequest request = new CommonRequest();
        request.setSysMethod(MethodType.POST);
        request.setSysDomain("dysmsapi.aliyuncs.com");
        request.setSysVersion("2017-05-25");
        request.setSysAction("SendSms");
        request.putQueryParameter("RegionId", this.smsConfigProperties.getRegionId());
        request.putQueryParameter("PhoneNumbers", phoneNumbers);
        request.putQueryParameter("SignName", signName);
        request.putQueryParameter("TemplateCode", templateCode);
        request.putQueryParameter("TemplateParam", templateParam);
        CommonResponse response = client.getCommonResponse(request);
        System.out.println(response.getData());
    }

    public SmsUtils(SmsConfigProperties smsConfigProperties) {
        this.smsConfigProperties = smsConfigProperties;
    }
}

