/*
 * Decompiled with CFR 0.152.
 */
package com.joolun.cloud.common.email.util;

import com.joolun.cloud.common.email.config.EmailConfigProperties;
import io.github.biezhi.ome.OhMyEmail;
import io.github.biezhi.ome.SendMailException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;

@Configuration
public class EmailUtils {
    private static final Logger log = LoggerFactory.getLogger(EmailUtils.class);
    private final EmailConfigProperties emailConfigProperties;

    public void sendEmail(String to, String title, String content) throws SendMailException {
        OhMyEmail.subject((String)title).from(this.emailConfigProperties.getSiteName()).to(to).html(content).send();
        log.info("email: {} send success", (Object)to);
    }

    public EmailUtils(EmailConfigProperties emailConfigProperties) {
        this.emailConfigProperties = emailConfigProperties;
    }
}

