/*
 * Decompiled with CFR 0.152.
 */
package com.joolun.cloud.common.datasource.config;

import com.alibaba.druid.pool.DruidDataSource;
import com.joolun.cloud.common.datasource.config.DruidDataSourceProperties;
import com.joolun.cloud.common.datasource.config.DynamicDataSource;
import com.mysql.cj.jdbc.Driver;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.PostConstruct;
import javax.sql.DataSource;
import org.jasypt.encryption.StringEncryptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.jdbc.datasource.DriverManagerDataSource;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.TransactionManagementConfigurer;

@Configuration
public class DynamicDataSourceConfig
implements TransactionManagementConfigurer {
    private static final Logger log = LoggerFactory.getLogger(DynamicDataSourceConfig.class);
    private final Map<Object, Object> dataSourceMap = new HashMap<Object, Object>(8);
    private final DruidDataSourceProperties dataSourceProperties;
    private final StringEncryptor stringEncryptor;

    @Bean(value={"dynamicDataSource"})
    public DynamicDataSource dataSource() {
        DynamicDataSource ds = new DynamicDataSource();
        DruidDataSource cads = new DruidDataSource();
        cads.setUrl(this.dataSourceProperties.getUrl());
        cads.setDriverClassName(this.dataSourceProperties.getDriverClassName());
        cads.setUsername(this.dataSourceProperties.getUsername());
        cads.setPassword(this.dataSourceProperties.getPassword());
        ds.setDefaultTargetDataSource(cads);
        this.dataSourceMap.put(0, cads);
        ds.setTargetDataSources(this.dataSourceMap);
        return ds;
    }

    @PostConstruct
    public void init() {
        DriverManagerDataSource dds = new DriverManagerDataSource();
        dds.setUrl(this.dataSourceProperties.getUrl());
        dds.setDriverClassName(this.dataSourceProperties.getDriverClassName());
        dds.setUsername(this.dataSourceProperties.getUsername());
        dds.setPassword(this.dataSourceProperties.getPassword());
        List dbList = new JdbcTemplate((DataSource)dds).queryForList("select * from sys_datasource where del_flag = 0");
        log.info("\u5f00\u59cb -> \u521d\u59cb\u5316\u52a8\u6001\u6570\u636e\u6e90");
        Optional.of(dbList).ifPresent(list -> list.forEach(db -> {
            log.info("\u6570\u636e\u6e90:{}", db.get("name"));
            DruidDataSource ds = new DruidDataSource();
            ds.setUrl(String.valueOf(db.get("url")));
            ds.setDriverClassName(Driver.class.getName());
            ds.setUsername(String.valueOf(db.get("username")));
            String decPwd = this.stringEncryptor.decrypt(String.valueOf(db.get("password")));
            ds.setPassword(decPwd);
            this.dataSourceMap.put(db.get("id"), ds);
        }));
        log.info("\u5b8c\u6bd5 -> \u521d\u59cb\u5316\u52a8\u6001\u6570\u636e\u6e90,\u5171\u8ba1 {} \u6761", (Object)this.dataSourceMap.size());
    }

    public Boolean reload() {
        this.init();
        DynamicDataSource dataSource = this.dataSource();
        dataSource.setTargetDataSources(this.dataSourceMap);
        dataSource.afterPropertiesSet();
        return Boolean.FALSE;
    }

    @Bean
    public PlatformTransactionManager txManager() {
        return new DataSourceTransactionManager((DataSource)((Object)this.dataSource()));
    }

    public PlatformTransactionManager annotationDrivenTransactionManager() {
        return this.txManager();
    }

    public DynamicDataSourceConfig(DruidDataSourceProperties dataSourceProperties, StringEncryptor stringEncryptor) {
        this.dataSourceProperties = dataSourceProperties;
        this.stringEncryptor = stringEncryptor;
    }
}

