/*
 * Decompiled with CFR 0.152.
 */
package com.joolun.cloud.common.core.util;

import cn.hutool.core.codec.Base64;
import cn.hutool.json.JSONUtil;
import com.joolun.cloud.common.core.exception.CheckedException;
import com.joolun.cloud.common.core.util.ClassUtils;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.method.HandlerMethod;

public final class WebUtils
extends org.springframework.web.util.WebUtils {
    private static final Logger log = LoggerFactory.getLogger(WebUtils.class);
    private static final String BASIC_ = "Basic ";
    private static final String UNKNOWN = "unknown";

    public static boolean isBody(HandlerMethod handlerMethod) {
        ResponseBody responseBody = ClassUtils.getAnnotation(handlerMethod, ResponseBody.class);
        return responseBody != null;
    }

    public static String getCookieVal(String name) {
        HttpServletRequest request = WebUtils.getRequest();
        Assert.notNull((Object)request, (String)"request from RequestContextHolder is null");
        return WebUtils.getCookieVal(request, name);
    }

    public static String getCookieVal(HttpServletRequest request, String name) {
        Cookie cookie = WebUtils.getCookie((HttpServletRequest)request, (String)name);
        return cookie != null ? cookie.getValue() : null;
    }

    public static void removeCookie(HttpServletResponse response, String key) {
        WebUtils.setCookie(response, key, null, 0);
    }

    public static void setCookie(HttpServletResponse response, String name, String value, int maxAgeInSeconds) {
        Cookie cookie = new Cookie(name, value);
        cookie.setPath("/");
        cookie.setMaxAge(maxAgeInSeconds);
        cookie.setHttpOnly(true);
        response.addCookie(cookie);
    }

    public static HttpServletRequest getRequest() {
        return ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
    }

    public static HttpServletResponse getResponse() {
        return ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getResponse();
    }

    public static void renderJson(HttpServletResponse response, Object result) {
        WebUtils.renderJson(response, result, "application/json;charset=UTF-8");
    }

    public static void renderJson(HttpServletResponse response, Object result, String contentType) {
        response.setCharacterEncoding("UTF-8");
        response.setContentType(contentType);
        try (PrintWriter out = response.getWriter();){
            out.append(JSONUtil.toJsonStr((Object)result));
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public static String getIP() {
        return WebUtils.getIP(WebUtils.getRequest());
    }

    public static String getIP(HttpServletRequest request) {
        Assert.notNull((Object)request, (String)"HttpServletRequest is null");
        String ip = request.getHeader("X-Requested-For");
        if (StringUtils.isBlank((String)ip) || UNKNOWN.equalsIgnoreCase(ip)) {
            ip = request.getHeader("X-Forwarded-For");
        }
        if (StringUtils.isBlank((String)ip) || UNKNOWN.equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (StringUtils.isBlank((String)ip) || UNKNOWN.equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (StringUtils.isBlank((String)ip) || UNKNOWN.equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_CLIENT_IP");
        }
        if (StringUtils.isBlank((String)ip) || UNKNOWN.equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_X_FORWARDED_FOR");
        }
        if (StringUtils.isBlank((String)ip) || UNKNOWN.equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        return StringUtils.isBlank((String)ip) ? null : ip.split(",")[0];
    }

    public static String[] getClientId(ServerHttpRequest request) {
        byte[] decoded;
        String header = request.getHeaders().getFirst("Authorization");
        if (header == null || !header.startsWith(BASIC_)) {
            throw new CheckedException("\u8bf7\u6c42\u5934\u4e2dclient\u4fe1\u606f\u4e3a\u7a7a");
        }
        byte[] base64Token = header.substring(6).getBytes("UTF-8");
        try {
            decoded = Base64.decode((byte[])base64Token);
        }
        catch (IllegalArgumentException e) {
            throw new CheckedException("Failed to decode basic authentication token");
        }
        String token = new String(decoded, StandardCharsets.UTF_8);
        int delim = token.indexOf(":");
        if (delim == -1) {
            throw new CheckedException("Invalid basic authentication token");
        }
        return new String[]{token.substring(0, delim), token.substring(delim + 1)};
    }

    private WebUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

