/*
 * Decompiled with CFR 0.152.
 */
package com.joolun.cloud.common.core.util;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import javax.imageio.ImageIO;

public class WaterMarkUtils {
    public static File markStr(File imgFile, Color markContentColor, String waterMarkContent) {
        try {
            BufferedImage bufImg = ImageIO.read(imgFile);
            int width = bufImg.getWidth();
            int height = bufImg.getHeight();
            Graphics2D g = bufImg.createGraphics();
            g.drawImage(bufImg, 0, 0, width, height, null);
            Font font = new Font("\u5fae\u8f6f\u96c5\u9ed1", 2, 45);
            g.setColor(markContentColor);
            g.setFont(font);
            int x = width - 2 * WaterMarkUtils.getWatermarkLength(waterMarkContent, g);
            int y = height - 1 * WaterMarkUtils.getWatermarkLength(waterMarkContent, g);
            g.drawString(waterMarkContent, x, y);
            g.dispose();
            ImageIO.write((RenderedImage)bufImg, "png", imgFile);
            return imgFile;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static int getWatermarkLength(String waterMarkContent, Graphics2D g) {
        return g.getFontMetrics(g.getFont()).charsWidth(waterMarkContent.toCharArray(), 0, waterMarkContent.length());
    }
}

