/*
 * Decompiled with CFR 0.152.
 */
package cn.tyoui.sogou;

import cn.tyoui.analysis.SoGouToTxT;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class SoGou
extends SoGouToTxT {
    private Set<String> set = new HashSet<String>();
    private String loadPath = "./sogou_url.txt";

    private void analysisSoGou() throws IOException {
        String root = "https://pinyin.sogou.com/dict/cate/index/";
        for (int i = 0; i <= 437; ++i) {
            String u = root + i + "/default/";
            int f = 1;
            for (int flag = 1; flag <= f; ++flag) {
                Document document = Jsoup.connect((String)(u + flag)).get();
                if (flag == 1) {
                    String num = document.getElementsByClass("cate_title").text();
                    int start = num.indexOf("\u5171\u6709") + 2;
                    int end = num.indexOf("\u4e2a\u8bcd\u5e93");
                    f = Integer.parseInt(num.substring(start, end)) / 10 + 1;
                }
                Elements name = document.getElementsByClass("detail_title");
                ArrayList<String> listName = new ArrayList<String>();
                for (Element n : name) {
                    String names = n.select("a").text();
                    listName.add(names);
                }
                Elements elements = document.getElementsByClass("dict_dl_btn");
                for (int j = 0; j < elements.size(); ++j) {
                    String url = ((Element)elements.get(j)).select("a").attr("href");
                    url = url + "\t" + (String)listName.get(j);
                    this.set.add(url);
                    System.out.println(url);
                }
            }
        }
    }

    private void write() throws IOException {
        FileWriter writer = new FileWriter(new File(this.loadPath));
        for (String line : this.set) {
            writer.write(line + "\n");
        }
        ((Writer)writer).flush();
        ((Writer)writer).close();
    }

    public void download_sogou() throws IOException {
        this.analysisSoGou();
        this.write();
    }

    public void download_url(String dic) throws Exception {
        File file = new File(this.loadPath);
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        File f = new File(dic);
        if (!f.exists()) {
            f.mkdirs();
        }
        while (bufferedReader.ready()) {
            int length;
            String str = bufferedReader.readLine();
            String name = str.split("\t")[1];
            name = name.replaceAll("[|/\u3001*;\".?<>\\\\]", "");
            FileOutputStream fileOutputStream = new FileOutputStream(dic + File.separator + name + ".scel");
            String url_str = str.split("\t")[0];
            URL url = new URL(url_str);
            DataInputStream dataInputStream = new DataInputStream(url.openStream());
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((length = dataInputStream.read(buffer)) > 0) {
                output.write(buffer, 0, length);
            }
            fileOutputStream.write(output.toByteArray());
            dataInputStream.close();
            fileOutputStream.close();
            System.out.println(url_str + "\u4e0b\u8f7d\u6210\u529f\uff01");
        }
        bufferedReader.close();
    }
}

