/*
 * Decompiled with CFR 0.152.
 */
package cn.tyoui.analysis;

import cn.tyoui.analysis.SouGouModel;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SoGouToTxT {
    private ByteArrayOutputStream output = new ByteArrayOutputStream();

    public void toTxt(String filePath, String targetFilePath, boolean isAppend) {
        File input = new File(filePath);
        try {
            FileInputStream in = new FileInputStream(input);
            SouGouModel model = this.readModel(in);
            if (model == null) {
                return;
            }
            this.writeToTargetFile(model, targetFilePath, isAppend);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SouGouModel readModel(InputStream in) {
        SouGouModel model = new SouGouModel();
        DataInputStream input = new DataInputStream(in);
        try {
            int size;
            String py;
            byte[] bytes = new byte[4];
            input.readFully(bytes);
            assert (bytes[0] == 64 && bytes[1] == 21 && bytes[2] == 0 && bytes[3] == 0);
            input.readFully(bytes);
            byte flag = bytes[0];
            assert (bytes[1] == 67 && bytes[2] == 83 && bytes[3] == 1);
            int[] reads = new int[]{8};
            model.setName(this.readString(input, 304, reads));
            model.setType(this.readString(input, 824, reads));
            int read = reads[0];
            input.skip(5440 - read);
            read = 5440;
            input.readFully(bytes);
            read += 4;
            assert (bytes[0] == -99 && bytes[1] == 1 && bytes[2] == 0 && bytes[3] == 0);
            bytes = new byte[128];
            LinkedHashMap<Integer, String> pyMap = new LinkedHashMap<Integer, String>();
            do {
                int mark = this.readUnsignedShort(input);
                int size2 = input.readUnsignedByte();
                input.skip(1L);
                read += 4;
                assert (size2 > 0 && size2 % 2 == 0);
                input.readFully(bytes, 0, size2);
                read += size2;
                py = new String(bytes, 0, size2, "UTF-16LE");
                pyMap.put(mark, py);
            } while (!"zuo".equals(py));
            if (flag == 68) {
                input.skip(9768 - read);
            } else if (flag == 69) {
                input.skip(9924 - read);
            } else {
                throw new RuntimeException("\u51fa\u73b0\u610f\u5916");
            }
            StringBuilder buffer = new StringBuilder();
            LinkedHashMap<String, List<String>> wordMap = new LinkedHashMap<String, List<String>>();
            while ((size = this.readUnsignedShort(input)) >= 0) {
                int count = this.readUnsignedShort(input);
                int len = count / 2;
                assert (len * 2 == count);
                buffer.setLength(0);
                for (int i = 0; i < len; ++i) {
                    int key = this.readUnsignedShort(input);
                    buffer.append((String)pyMap.get(key)).append("'");
                }
                buffer.setLength(buffer.length() - 1);
                String py2 = buffer.toString();
                ArrayList<String> list = (ArrayList<String>)wordMap.get(py2);
                if (list == null) {
                    list = new ArrayList<String>();
                    wordMap.put(py2, list);
                }
                for (int i = 0; i < size; ++i) {
                    count = this.readUnsignedShort(input);
                    if (count > bytes.length) {
                        bytes = new byte[count];
                    }
                    input.readFully(bytes, 0, count);
                    String word = new String(bytes, 0, count, "UTF-16LE");
                    input.skip(12L);
                    list.add(word);
                }
            }
            model.setWordMap(wordMap);
            SouGouModel souGouModel = model;
            return souGouModel;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private void writeToTargetFile(SouGouModel souGouModel, String targetFilePath, boolean isAppend) throws IOException {
        FileOutputStream out = new FileOutputStream(targetFilePath, isAppend);
        Map<String, List<String>> words = souGouModel.getWordMap();
        Set<Map.Entry<String, List<String>>> set = words.entrySet();
        for (Map.Entry<String, List<String>> entry : set) {
            List<String> list = entry.getValue();
            for (String word : list) {
                out.write((entry.getKey() + "\t").getBytes());
                out.write((word + "\n").getBytes());
            }
        }
        out.close();
    }

    private int readUnsignedShort(InputStream in) throws IOException {
        int ch2;
        int ch1 = in.read();
        if ((ch1 | (ch2 = in.read())) < 0) {
            return Integer.MIN_VALUE;
        }
        return (ch2 << 8) + ch1;
    }

    private String readString(DataInputStream input, int pos, int[] reads) throws IOException {
        int read = reads[0];
        input.skip(pos - read);
        read = pos;
        this.output.reset();
        while (true) {
            int c1 = input.read();
            int c2 = input.read();
            read += 2;
            if (c1 == 0 && c2 == 0) break;
            this.output.write(c1);
            this.output.write(c2);
        }
        reads[0] = read;
        return new String(this.output.toByteArray(), "UTF-16LE");
    }
}

