/*
 * Decompiled with CFR 0.152.
 */
package cn.tyoui.ui;

import cn.tyoui.index.FileAnalyzer;
import cn.tyoui.pojo.FileMessage;
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.ListModel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class IndexUtils
extends JFrame {
    private JButton createButton;
    private JButton deleteButton;
    private JLabel dirLabel;
    private JTextField dirText;
    private JRadioButton fileContent;
    private JLabel jLabel;
    private JList<String> listText;
    private JScrollPane scrollPane;
    private JButton searchButton;
    private JLabel searchNameLabel;
    private JTextField searchText;
    private JLabel selectLabel;
    private JSeparator separator;
    private JLabel timeLabel;
    private JButton updateButton;
    private FileAnalyzer fileAnalyzer = new FileAnalyzer();

    public IndexUtils() {
        this.initComponents();
    }

    private void initComponents() {
        this.jLabel = new JLabel();
        this.fileContent = new JRadioButton();
        this.searchNameLabel = new JLabel();
        this.searchButton = new JButton();
        this.searchText = new JTextField();
        this.separator = new JSeparator();
        this.scrollPane = new JScrollPane();
        this.listText = new JList();
        this.createButton = new JButton();
        this.updateButton = new JButton();
        this.deleteButton = new JButton();
        this.selectLabel = new JLabel();
        this.dirText = new JTextField();
        this.dirLabel = new JLabel();
        this.timeLabel = new JLabel();
        if (this.fileAnalyzer.isIndexExists()) {
            this.createButton.setEnabled(false);
        }
        this.jLabel.setText("jLabel1");
        this.setDefaultCloseOperation(3);
        this.setTitle("\u4f1f\u54e5\u7248\u5168\u6587\u68c0\u7d22");
        this.fileContent.setText("\u662f\u5426\u6309\u6587\u4ef6\u5185\u5bb9\u641c\u7d22");
        this.searchNameLabel.setFont(new Font("\u5b8b\u4f53", 0, 14));
        this.searchNameLabel.setText("*\u5168\u6587\u641c\u7d22");
        this.searchButton.setFont(new Font("\u5b8b\u4f53", 0, 14));
        this.searchButton.setText("\u641c\u7d22");
        this.searchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IndexUtils.this.searchButtonActionPerformed(evt);
            }
        });
        this.scrollPane.setViewportView(this.listText);
        this.createButton.setText("\u521d\u59cb\u5316\u7d22\u5f15");
        this.createButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IndexUtils.this.createButtonActionPerformed(evt);
            }
        });
        this.updateButton.setText("\u66f4\u65b0\u7d22\u5f15");
        this.updateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IndexUtils.this.updateButtonActionPerformed(evt);
            }
        });
        this.deleteButton.setText("\u5220\u9664\u7d22\u5f15");
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IndexUtils.this.deleteButtonActionPerformed(evt);
            }
        });
        this.selectLabel.setFont(new Font("\u5b8b\u4f53", 0, 14));
        this.selectLabel.setText("\u9ed8\u8ba4\u662f\u6309\u6587\u4ef6\u540d\u5b57\u641c\u7d22");
        this.dirLabel.setFont(new Font("\u5b8b\u4f53", 0, 14));
        this.dirLabel.setText("\u641c\u7d22\u6587\u4ef6\u5939");
        this.timeLabel.setFont(new Font("\u5b8b\u4f53", 0, 14));
        this.timeLabel.setForeground(new Color(255, 0, 51));
        this.timeLabel.setText("\u6d88\u8017\u65f6\u95f4");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(5, 5, 5).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.separator).addComponent(this.scrollPane, -1, 510, Short.MAX_VALUE))).addGroup(layout.createSequentialGroup().addGap(46, 46, 46).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.createButton).addGroup(layout.createSequentialGroup().addComponent(this.searchNameLabel, -2, 81, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout.createSequentialGroup().addComponent(this.dirLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.dirText).addGap(22, 22, 22)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.updateButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.deleteButton)).addComponent(this.searchText, GroupLayout.Alignment.TRAILING, -2, 362, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.searchButton).addGap(8, 8, 8))).addGap(0, 13, Short.MAX_VALUE))).addContainerGap(24, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGap(231, 231, 231).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.timeLabel).addGroup(layout.createSequentialGroup().addGap(10, 10, 10).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.fileContent, -1, -1, Short.MAX_VALUE).addComponent(this.selectLabel, -1, 149, Short.MAX_VALUE)))).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.dirText, -2, -1, -2).addComponent(this.dirLabel).addComponent(this.createButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.searchNameLabel).addComponent(this.searchButton).addComponent(this.searchText, -2, -1, -2)).addGap(3, 3, 3).addComponent(this.timeLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.updateButton).addComponent(this.deleteButton).addComponent(this.fileContent)).addGap(18, 18, 18).addComponent(this.selectLabel, -2, 19, -2).addGap(6, 6, 6).addComponent(this.separator, -2, -1, -2).addGap(18, 18, 18).addComponent(this.scrollPane, -2, 330, -2).addContainerGap(35, Short.MAX_VALUE)));
        this.pack();
        this.setLocationRelativeTo(null);
    }

    private void createButtonActionPerformed(ActionEvent evt) {
        String dir = this.dirText.getText();
        this.fileAnalyzer.setCreateIndexDir(dir);
        this.fileAnalyzer.createIndex();
        this.createButton.setEnabled(false);
    }

    private void updateButtonActionPerformed(ActionEvent evt) {
        String dir = this.dirText.getText();
        this.fileAnalyzer.setCreateIndexDir(dir);
        this.fileAnalyzer.update();
    }

    private void deleteButtonActionPerformed(ActionEvent evt) {
        try {
            this.fileAnalyzer.closeAll();
            this.fileAnalyzer.deleteAllFilesOfDir();
            this.createButton.setEnabled(true);
            this.fileAnalyzer = new FileAnalyzer();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void searchButtonActionPerformed(ActionEvent evt) {
        String context = this.searchText.getText();
        if (this.fileContent.isSelected()) {
            context = "fileContent:" + context;
        }
        long start = System.currentTimeMillis();
        List<FileMessage> list = this.fileAnalyzer.searchIndex(context, 10000);
        long end = System.currentTimeMillis() - start;
        final String[] strings = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            strings[i] = new String("\u5f97\u5206:" + list.get(i).getScore() + "-->" + list.get(i).getFilePath());
        }
        this.listText.setModel((ListModel<String>)new AbstractListModel<String>(){

            @Override
            public int getSize() {
                return strings.length;
            }

            @Override
            public String getElementAt(int i) {
                return strings[i];
            }
        });
        this.timeLabel.setText("\u4e00\u5171\u627e\u5230" + list.size() + "\u4e2a\u5e76\u4e14\u8017\u65f6:" + end + "\u6beb\u79d2\uff01");
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(IndexUtils.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(IndexUtils.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(IndexUtils.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(IndexUtils.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new IndexUtils().setVisible(true);
            }
        });
    }
}

