/*
 * Decompiled with CFR 0.152.
 */
package cn.tyoui.index;

import cn.tyoui.index.FileContent;
import cn.tyoui.pojo.FileMessage;
import com.chenlb.mmseg4j.analysis.MMSegAnalyzer;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;

public class FileAnalyzer {
    private Analyzer analyzer = new MMSegAnalyzer();
    private String indexPath = "D:\\index";
    private IndexWriter indexWriter = null;
    private IndexReader indexReader = null;
    private Directory directory = null;
    private List<FileMessage> list = new ArrayList<FileMessage>();
    private Map<String, Long> map = new HashMap<String, Long>();
    private String createIndexDir = null;
    private List<String> li = null;
    private File fileIndex = new File(this.indexPath);

    public void setCreateIndexDir(String createIndexDir) {
        this.createIndexDir = createIndexDir;
    }

    public FileAnalyzer() {
        try {
            Path path = FileSystems.getDefault().getPath(this.indexPath, new String[0]);
            this.directory = FSDirectory.open((Path)path);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void close() {
        try {
            this.indexWriter.commit();
            this.indexWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void analyzerDir(File dir) throws Exception {
        if (dir.isDirectory()) {
            File[] file;
            for (File f : file = dir.listFiles()) {
                if (f.isDirectory()) {
                    this.analyzerDir(f);
                    continue;
                }
                this.createIndex(f);
            }
        } else {
            this.createIndex(dir);
        }
    }

    private void document(File file, Document document) {
        String context = FileContent.init(file);
        document.add((IndexableField)new Field("filePath", file.getAbsolutePath(), StringField.TYPE_STORED));
        document.add((IndexableField)new Field("fileName", file.getName(), TextField.TYPE_NOT_STORED));
        document.add((IndexableField)new Field("fileContent", context, TextField.TYPE_NOT_STORED));
    }

    private void createIndex(File file) {
        try {
            FileMessage message = new FileMessage(file.getAbsolutePath(), file.length());
            this.list.add(message);
            Document document = new Document();
            this.document(file, document);
            this.indexWriter.addDocument((Iterable)document);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void updateIndex(File file) {
        try {
            Document document = new Document();
            this.document(file, document);
            this.indexWriter.updateDocument(new Term("filePath", file.getAbsolutePath()), (Iterable)document);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void updateDir(File dir) throws Exception {
        File[] file = dir.listFiles();
        if (file != null) {
            for (File f : file) {
                if (f.isDirectory()) {
                    this.updateDir(f);
                    continue;
                }
                if (this.map.get(f.getAbsolutePath()) != null) {
                    if (this.map.get(f.getAbsolutePath()).longValue() == f.length()) continue;
                    this.updateIndex(f);
                    this.addDir(f.getAbsolutePath(), f.length());
                    continue;
                }
                this.createIndex(f);
            }
        }
    }

    private void addDir(String filePath, long size) {
        ArrayList<String> list = new ArrayList<String>();
        for (String content : this.li) {
            if (content.startsWith(filePath)) continue;
            list.add(content);
        }
        list.add(filePath + "\t" + size);
        try {
            this.li = list;
            this.writeFile(false);
            System.out.println("\u66f4\u65b0\u6210\u529f\uff01");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void addDir() {
        try {
            if (this.list.size() > 0) {
                for (FileMessage fileMessage : this.list) {
                    this.li.add(fileMessage.toString());
                }
                this.writeFile(false);
                System.out.println("\u8ffd\u52a0\u6210\u529f\uff01");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void createIndex() {
        try {
            File file = new File(this.indexPath + File.separator + "dir.txt");
            if (file.exists()) {
                file.delete();
            }
            this.indexWriter = new IndexWriter(this.directory, new IndexWriterConfig(this.analyzer));
            this.analyzerDir(new File(this.createIndexDir));
            this.close();
            this.writeFile(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void update() {
        try {
            this.li = FileUtils.readLines((File)new File(this.indexPath + File.separator + "dir.txt"), (String)"UTF-8");
            for (String text : this.li) {
                String[] string = text.split("\t");
                this.map.put(string[0], Long.parseLong(string[1]));
            }
            this.indexWriter = new IndexWriter(this.directory, new IndexWriterConfig(this.analyzer));
            this.updateDir(new File(this.createIndexDir));
            this.indexWriter.commit();
            this.indexWriter.close();
            this.addDir();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public List<FileMessage> searchIndex(String key, int number) {
        ArrayList<FileMessage> list = new ArrayList<FileMessage>();
        try {
            this.indexReader = DirectoryReader.open((Directory)this.directory);
            IndexSearcher indexSearcher = new IndexSearcher(this.indexReader);
            QueryParser queryParser = new QueryParser("fileName", this.analyzer);
            Query query = queryParser.parse(key);
            TopDocs topDocs = indexSearcher.search(query, number);
            for (ScoreDoc scoreDoc : topDocs.scoreDocs) {
                Document document = indexSearcher.doc(scoreDoc.doc);
                FileMessage fileMessage = new FileMessage(document.get("filePath"), scoreDoc.score);
                list.add(fileMessage);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public boolean isIndexExists() {
        return this.fileIndex.exists() && this.fileIndex.listFiles().length > 0;
    }

    public void deleteAllFilesOfDir() {
        for (File file : this.fileIndex.listFiles()) {
            file.delete();
        }
    }

    public void closeAll() throws Exception {
        if (this.indexWriter != null) {
            this.indexWriter.close();
        }
        if (this.indexReader != null) {
            this.indexReader.close();
        }
        if (this.directory != null) {
            this.directory.close();
        }
    }

    private void writeFile(boolean listFlag) {
        try {
            if (listFlag) {
                FileUtils.writeLines((File)new File(this.indexPath + File.separator + "dir.txt"), this.list);
                this.list.clear();
            } else {
                FileUtils.writeLines((File)new File(this.indexPath + File.separator + "dir.txt"), this.li);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

