package cn.tyoui.ui;


import cn.tyoui.index.FileAnalyzer;
import cn.tyoui.pojo.FileMessage;

import java.util.List;

/**
 * 界面类
 *
 * @author Tyoui
 */
public class IndexUtils extends javax.swing.JFrame {
    private javax.swing.JButton createButton;
    private javax.swing.JButton deleteButton;
    private javax.swing.JLabel dirLabel;
    private javax.swing.JTextField dirText;
    private javax.swing.JRadioButton fileContent;
    private javax.swing.JLabel jLabel;
    private javax.swing.JList<String> listText;
    private javax.swing.JScrollPane scrollPane;
    private javax.swing.JButton searchButton;
    private javax.swing.JLabel searchNameLabel;
    private javax.swing.JTextField searchText;
    private javax.swing.JLabel selectLabel;
    private javax.swing.JSeparator separator;
    private javax.swing.JLabel timeLabel;
    private javax.swing.JButton updateButton;
    private FileAnalyzer fileAnalyzer = new FileAnalyzer();

    public IndexUtils() {
        initComponents();
    }

    private void initComponents() {
        jLabel = new javax.swing.JLabel();
        fileContent = new javax.swing.JRadioButton();
        searchNameLabel = new javax.swing.JLabel();
        searchButton = new javax.swing.JButton();
        searchText = new javax.swing.JTextField();
        separator = new javax.swing.JSeparator();
        scrollPane = new javax.swing.JScrollPane();
        listText = new javax.swing.JList<>();
        createButton = new javax.swing.JButton();
        updateButton = new javax.swing.JButton();
        deleteButton = new javax.swing.JButton();
        selectLabel = new javax.swing.JLabel();
        dirText = new javax.swing.JTextField();
        dirLabel = new javax.swing.JLabel();
        timeLabel = new javax.swing.JLabel();
        if (fileAnalyzer.isIndexExists()) {
            createButton.setEnabled(false);
        }
        jLabel.setText("jLabel1");
        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        setTitle("伟哥版全文检索");
        fileContent.setText("是否按文件内容搜索");
        searchNameLabel.setFont(new java.awt.Font("宋体", 0, 14)); 
        searchNameLabel.setText("*全文搜索");
        searchButton.setFont(new java.awt.Font("宋体", 0, 14));
        searchButton.setText("搜索");
        searchButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                searchButtonActionPerformed(evt);
            }
        });
        scrollPane.setViewportView(listText);
        createButton.setText("初始化索引");
        createButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                createButtonActionPerformed(evt);
            }
        });
        updateButton.setText("更新索引");
        updateButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                updateButtonActionPerformed(evt);
            }
        });

        deleteButton.setText("删除索引");
        deleteButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                deleteButtonActionPerformed(evt);
            }
        });
        selectLabel.setFont(new java.awt.Font("宋体", 0, 14)); 
        selectLabel.setText("默认是按文件名字搜索");
        dirLabel.setFont(new java.awt.Font("宋体", 0, 14)); 
        dirLabel.setText("搜索文件夹");
        timeLabel.setFont(new java.awt.Font("宋体", 0, 14)); 
        timeLabel.setForeground(new java.awt.Color(255, 0, 51));
        timeLabel.setText("消耗时间");
        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
                layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                        .addGroup(layout.createSequentialGroup()
                                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                        .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                                                .addGap(5, 5, 5)
                                                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                                                        .addComponent(separator)
                                                        .addComponent(scrollPane, javax.swing.GroupLayout.DEFAULT_SIZE, 510, Short.MAX_VALUE)))
                                        .addGroup(layout.createSequentialGroup()
                                                .addGap(46, 46, 46)
                                                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                                                        .addComponent(createButton)
                                                        .addGroup(layout.createSequentialGroup()
                                                                .addComponent(searchNameLabel, javax.swing.GroupLayout.PREFERRED_SIZE, 81, javax.swing.GroupLayout.PREFERRED_SIZE)
                                                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                                                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                                                                        .addGroup(layout.createSequentialGroup()
                                                                                .addComponent(dirLabel)
                                                                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                                                                .addComponent(dirText)
                                                                                .addGap(22, 22, 22))
                                                                        .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                                                                                .addComponent(updateButton)
                                                                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                                                                                .addComponent(deleteButton))
                                                                        .addComponent(searchText, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.PREFERRED_SIZE, 362, javax.swing.GroupLayout.PREFERRED_SIZE))
                                                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                                                .addComponent(searchButton)
                                                                .addGap(8, 8, 8)))
                                                .addGap(0, 13, Short.MAX_VALUE)))
                                .addContainerGap(24, Short.MAX_VALUE))
                        .addGroup(layout.createSequentialGroup()
                                .addGap(231, 231, 231)
                                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                        .addComponent(timeLabel)
                                        .addGroup(layout.createSequentialGroup()
                                                .addGap(10, 10, 10)
                                                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                                                        .addComponent(fileContent, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                                                        .addComponent(selectLabel, javax.swing.GroupLayout.DEFAULT_SIZE, 149, Short.MAX_VALUE))))
                                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
        layout.setVerticalGroup(
                layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                        .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                                .addContainerGap()
                                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                                        .addComponent(dirText, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                                        .addComponent(dirLabel)
                                        .addComponent(createButton))
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                                        .addComponent(searchNameLabel)
                                        .addComponent(searchButton)
                                        .addComponent(searchText, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                                .addGap(3, 3, 3)
                                .addComponent(timeLabel)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                                        .addComponent(updateButton)
                                        .addComponent(deleteButton)
                                        .addComponent(fileContent))
                                .addGap(18, 18, 18)
                                .addComponent(selectLabel, javax.swing.GroupLayout.PREFERRED_SIZE, 19, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addGap(6, 6, 6)
                                .addComponent(separator, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addGap(18, 18, 18)
                                .addComponent(scrollPane, javax.swing.GroupLayout.PREFERRED_SIZE, 330, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addContainerGap(35, Short.MAX_VALUE))
        );

        pack();
        setLocationRelativeTo(null);
    }

    private void createButtonActionPerformed(java.awt.event.ActionEvent evt) {
        String dir = dirText.getText();
        fileAnalyzer.setCreateIndexDir(dir);
        fileAnalyzer.createIndex();
        createButton.setEnabled(false);
    }

    private void updateButtonActionPerformed(java.awt.event.ActionEvent evt) {
        String dir = dirText.getText();
        fileAnalyzer.setCreateIndexDir(dir);
        fileAnalyzer.update();
    }

    private void deleteButtonActionPerformed(java.awt.event.ActionEvent evt) {
        try {
            fileAnalyzer.closeAll();
            fileAnalyzer.deleteAllFilesOfDir();
            createButton.setEnabled(true);
            fileAnalyzer = new FileAnalyzer();
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    private void searchButtonActionPerformed(java.awt.event.ActionEvent evt) {
        String context = searchText.getText();
        if (fileContent.isSelected())
            context = "fileContent:" + context;
        long start = System.currentTimeMillis();
        List<FileMessage> list = fileAnalyzer.searchIndex(context, 10000);
        long end = System.currentTimeMillis() - start;
        String[] strings = new String[list.size()];
        for (int i = 0; i < list.size(); i++)
            strings[i] = new String("得分:" + list.get(i).getScore() + "-->" + list.get(i).getFilePath());
        listText.setModel(new javax.swing.AbstractListModel<String>() {
            public int getSize() {
                return strings.length;
            }

            public String getElementAt(int i) {
                return strings[i];
            }
        });
        timeLabel.setText("一共找到" + list.size() + "个并且耗时:" + end + "毫秒！");
    }


    public static void main(String args[]) {
        try {
            for (javax.swing.UIManager.LookAndFeelInfo info : javax.swing.UIManager.getInstalledLookAndFeels()) {
                if ("Nimbus".equals(info.getName())) {
                    javax.swing.UIManager.setLookAndFeel(info.getClassName());
                    break;
                }
            }
        } catch (ClassNotFoundException ex) {
            java.util.logging.Logger.getLogger(IndexUtils.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (InstantiationException ex) {
            java.util.logging.Logger.getLogger(IndexUtils.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (IllegalAccessException ex) {
            java.util.logging.Logger.getLogger(IndexUtils.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (javax.swing.UnsupportedLookAndFeelException ex) {
            java.util.logging.Logger.getLogger(IndexUtils.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        }
        java.awt.EventQueue.invokeLater(new Runnable() {
            public void run() {
                new IndexUtils().setVisible(true);
            }
        });
    }
}
