/*
 * Decompiled with CFR 0.152.
 */
package cn.tyoui.httpclient;

import cn.tyoui.pojo.ProxyIP;
import cn.tyoui.pojo.StatusCode;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.commons.io.FileUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;

public class HttpCrawler {
    private CloseableHttpClient httpClient = HttpClients.createDefault();
    private List<ProxyIP> list = null;
    private String dir = null;

    public void proxyInit(String proxyText) throws Exception {
        this.list = new ArrayList<ProxyIP>();
        List listIP = FileUtils.readLines((File)new File(proxyText));
        for (String str : listIP) {
            String ip = str.split(":")[0];
            int port = Integer.parseInt(str.split(":")[1]);
            ProxyIP proxyIp = new ProxyIP(ip, port);
            this.list.add(proxyIp);
        }
    }

    public void startCrawler(String webURL, int min, Integer max) throws Exception {
        String path = this.dir + File.separator + webURL.substring(webURL.lastIndexOf("/") + 1) + ".html";
        File file = new File(path);
        if (file.exists()) {
            return;
        }
        if (this.getList() == null) {
            this.crawler(webURL, path, null, 0);
        } else {
            int index = new Random().nextInt(this.list.size() - 1);
            this.crawler(webURL, path, this.list.get(index), index);
        }
        if (max != null) {
            Thread.sleep(new Random().nextInt(max) + min);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void crawler(String url, String path, ProxyIP proxy, int index) throws CloneNotSupportedException, IOException {
        block11: {
            CloseableHttpResponse response = null;
            HttpGet httpGet = null;
            try {
                RequestConfig requestConfig;
                httpGet = new HttpGet(url);
                httpGet.setHeader("Accept", "text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,*/*;q=0.8");
                httpGet.setHeader("Accept-Encoding", "gzip,deflate,sdch");
                httpGet.setHeader("Accept-Language", "zh-CN,zh;q=0.8");
                httpGet.setHeader("User-Agent", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.87 Safari/537.36");
                if (proxy == null) {
                    requestConfig = RequestConfig.custom().setConnectTimeout(2000).setSocketTimeout(1000).build();
                } else {
                    HttpHost httpHost = new HttpHost(proxy.getIp(), proxy.getPort());
                    requestConfig = RequestConfig.custom().setProxy(httpHost).setConnectTimeout(2000).setSocketTimeout(1000).build();
                }
                httpGet.setConfig(requestConfig);
                response = this.httpClient.execute((HttpUriRequest)httpGet);
                int status = response.getStatusLine().getStatusCode();
                if (status >= 200 && status < 300 || status == 404) {
                    HttpEntity entity = response.getEntity();
                    entity.writeTo((OutputStream)new FileOutputStream(path));
                    System.out.println("\u4e0b\u8f7d\u6210\u529f\uff01" + url);
                    break block11;
                }
                if (this.list != null) {
                    this.list.remove(index);
                }
                throw new Exception(StatusCode.getStatus(status));
            }
            catch (Exception e) {
                System.err.println(e + "\t" + url);
            }
            finally {
                if (httpGet != null) {
                    httpGet.clone();
                }
                if (response != null) {
                    response.close();
                }
            }
        }
    }

    public void setDir(String dir) {
        this.dir = dir;
        File file = new File(dir);
        if (!file.exists()) {
            file.mkdirs();
        }
    }

    public void close() {
        try {
            this.httpClient.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public List<ProxyIP> getList() {
        return this.list;
    }

    public void setList(List<ProxyIP> list) {
        this.list = list;
    }
}

