package cn.tworice.watermark.client;

import cn.tworice.common.util.StringUtils;
import cn.tworice.watermark.WaterMarkClient;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

import javax.imageio.ImageIO;
import java.awt.*;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;

@Service("waterMarkClient")
public class DefaultWaterMarkClient implements WaterMarkClient {
    @Value("${tworice.mark.name:二饭}")
    private String waterMark;

    @Override
    public BufferedImage mark(Image image) {
        //获取图片的宽
        int srcImgWidth = image.getWidth(null);
        //获取图片的高
        int srcImgHeight = image.getHeight(null);
        BufferedImage bufImg = new BufferedImage(srcImgWidth, srcImgHeight, BufferedImage.TYPE_INT_RGB);
        // 加水印
        //创建画笔
        Graphics2D g = bufImg.createGraphics();
        //srcImg 为上面获取到的原始图片的图片对象
        g.drawImage(image, 0, 0, srcImgWidth, srcImgHeight, null);
        //根据图片的背景设置水印颜色
        g.setColor(new Color(255,255,255,128));
        //设置字体  画笔字体样式为微软雅黑，加粗，文字大小为60pt
        g.setFont(new Font("微软雅黑", Font.BOLD, 60));
        //设置水印的坐标
        //int x=200;
        //int y=200;
        int x=(srcImgWidth - getWatermarkLength(waterMark, g)) / 2;
        int y=srcImgHeight / 2;
        //画出水印 第一个参数是水印内容，第二个参数是x轴坐标，第三个参数是y轴坐标
        g.drawString(this.waterMark, x, y);
        g.dispose();


        return bufImg;
    }

    @Override
    public BufferedImage mark(String imagePath) throws IOException {
        return this.mark(ImageIO.read(new File(imagePath)));
    }

    @Override
    public BufferedImage mark(MultipartFile file) throws IOException {
        return this.mark(ImageIO.read(file.getInputStream()));
    }

    @Override
    public BufferedImage mark(MultipartFile file, String content) throws IOException {
        if(StringUtils.isEmpty(content)){
            throw new RuntimeException("水印不能为空");
        }
        BufferedImage image = ImageIO.read(file.getInputStream());
        //获取图片的宽
        int srcImgWidth = image.getWidth(null);
        //获取图片的高
        int srcImgHeight = image.getHeight(null);
        BufferedImage bufImg = new BufferedImage(srcImgWidth, srcImgHeight, BufferedImage.TYPE_INT_RGB);
        // 加水印
        //创建画笔
        Graphics2D g = bufImg.createGraphics();
        //srcImg 为上面获取到的原始图片的图片对象
        g.drawImage(image, 0, 0, srcImgWidth, srcImgHeight, null);
        //根据图片的背景设置水印颜色
        g.setColor(new Color(255,255,255,128));
        //设置字体  画笔字体样式为微软雅黑，加粗，文字大小为60pt
        g.setFont(new Font("微软雅黑", Font.BOLD, 60));
        //设置水印的坐标
        //int x=200;
        //int y=200;
        int x=(srcImgWidth - getWatermarkLength(content, g)) / 2;
        int y=srcImgHeight / 2;
        //画出水印 第一个参数是水印内容，第二个参数是x轴坐标，第三个参数是y轴坐标
        g.drawString(content, x, y);
        g.dispose();


        return bufImg;
    }

    /**
     * 获取水印文字的长度
     */
    public int getWatermarkLength(String waterMarkContent, Graphics2D g) {
        return g.getFontMetrics(g.getFont()).charsWidth(waterMarkContent.toCharArray(), 0, waterMarkContent.length());
    }

}
