/*
 * Decompiled with CFR 0.152.
 */
package cn.tworice.watermark.web;

import cn.tworice.common.util.file.FileConvertUtil;
import cn.tworice.common.vo.RequestResult;
import cn.tworice.watermark.WaterMarkClient;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"admin/mark"})
@CrossOrigin
public class WaterMarkController {
    private static final Logger log = LoggerFactory.getLogger(WaterMarkController.class);
    @Resource
    private WaterMarkClient waterMarkClient;

    @PostMapping
    public RequestResult mark(MultipartFile img) throws IOException {
        String base64 = FileConvertUtil.convertToBase64((BufferedImage)this.waterMarkClient.mark(img));
        return RequestResult.success().appendData("base64", (Object)base64);
    }

    @PostMapping(value={"content"})
    public RequestResult mark(MultipartFile img, String content) throws IOException {
        String base64 = FileConvertUtil.convertToBase64((BufferedImage)this.waterMarkClient.mark(img, content));
        return RequestResult.success().appendData("base64", (Object)base64);
    }
}

