/*
 * Decompiled with CFR 0.152.
 */
package cn.tworice.watermark.client;

import cn.tworice.common.util.StringUtils;
import cn.tworice.watermark.WaterMarkClient;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service(value="waterMarkClient")
public class DefaultWaterMarkClient
implements WaterMarkClient {
    @Value(value="${tworice.mark.name:\u4e8c\u996d}")
    private String waterMark;

    @Override
    public BufferedImage mark(Image image) {
        int srcImgWidth = image.getWidth(null);
        int srcImgHeight = image.getHeight(null);
        BufferedImage bufImg = new BufferedImage(srcImgWidth, srcImgHeight, 1);
        Graphics2D g = bufImg.createGraphics();
        g.drawImage(image, 0, 0, srcImgWidth, srcImgHeight, null);
        g.setColor(new Color(255, 255, 255, 128));
        g.setFont(new Font("\u5fae\u8f6f\u96c5\u9ed1", 1, 60));
        int x = (srcImgWidth - this.getWatermarkLength(this.waterMark, g)) / 2;
        int y = srcImgHeight / 2;
        g.drawString(this.waterMark, x, y);
        g.dispose();
        return bufImg;
    }

    @Override
    public BufferedImage mark(String imagePath) throws IOException {
        return this.mark(ImageIO.read(new File(imagePath)));
    }

    @Override
    public BufferedImage mark(MultipartFile file) throws IOException {
        return this.mark(ImageIO.read(file.getInputStream()));
    }

    @Override
    public BufferedImage mark(MultipartFile file, String content) throws IOException {
        if (StringUtils.isEmpty((String)content)) {
            throw new RuntimeException("\u6c34\u5370\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BufferedImage image = ImageIO.read(file.getInputStream());
        int srcImgWidth = image.getWidth(null);
        int srcImgHeight = image.getHeight(null);
        BufferedImage bufImg = new BufferedImage(srcImgWidth, srcImgHeight, 1);
        Graphics2D g = bufImg.createGraphics();
        g.drawImage(image, 0, 0, srcImgWidth, srcImgHeight, null);
        g.setColor(new Color(255, 255, 255, 128));
        g.setFont(new Font("\u5fae\u8f6f\u96c5\u9ed1", 1, 60));
        int x = (srcImgWidth - this.getWatermarkLength(content, g)) / 2;
        int y = srcImgHeight / 2;
        g.drawString(content, x, y);
        g.dispose();
        return bufImg;
    }

    public int getWatermarkLength(String waterMarkContent, Graphics2D g) {
        return g.getFontMetrics(g.getFont()).charsWidth(waterMarkContent.toCharArray(), 0, waterMarkContent.length());
    }
}

