package cn.tworice.watermark.web;

import cn.tworice.common.util.file.FileConvertUtil;
import cn.tworice.common.vo.RequestResult;
import cn.tworice.watermark.WaterMarkClient;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

import javax.annotation.Resource;
import java.io.IOException;

@RestController
@RequestMapping("admin/mark")
@Slf4j
@CrossOrigin
public class WaterMarkController {

    @Resource
    private WaterMarkClient waterMarkClient;

    @PostMapping()
    public RequestResult mark(MultipartFile img) throws IOException {
        String base64 = FileConvertUtil.convertToBase64(waterMarkClient.mark(img));
        return RequestResult.success().appendData("base64",base64);
    }

    @PostMapping("content")
    public RequestResult mark(MultipartFile img,String content) throws IOException {
        String base64 = FileConvertUtil.convertToBase64(waterMarkClient.mark(img,content));
        return RequestResult.success().appendData("base64",base64);
    }
}
