package cn.tworice.verify.service.impl;

import cn.tworice.common.util.AgingMap;
import cn.tworice.verify.service.OnlineService;
import org.springframework.stereotype.Service;

import java.util.*;

@Service
public class OnlineServiceImpl implements OnlineService {

    /**
     * 在线用户存储Map
     * <用户ID,用户Token>
     **/
    private final AgingMap<String, String> onlineMap = new AgingMap<>();


    private final Map<String,List<String>> ADMIN_RESOURCES = new HashMap<>();

    @Override
    public boolean offline(String key) {
        return this.onlineMap.remove(key) != null;
    }

    @Override
    public Map<String, String> onlineMap() {
        return this.onlineMap.getMap();
    }

    @Override
    public boolean exist(String key, String obj) {
        return this.onlineMap.exist(key,obj);
    }

    @Override
    public boolean online(String key, String token) {
        onlineMap.put(key, token);
        return false;
    }

    /**
     * 保存用户的权限列表
     * @param adminID 用户ID
     * @param list 用户权限列表
     * @return boolean
     * @author 二饭 [2022/10/8]
     **/
    public boolean addAdminResources(String adminID, String[] list) {
        List<String> urls = Arrays.asList(list);
        System.out.println("当前用户资源列表："+urls.toString());
        return this.ADMIN_RESOURCES.put(adminID, urls) != null;
    }

    @Override
    public boolean authAdminResource(String adminID, String url) {
        List<String> urls = this.ADMIN_RESOURCES.get(adminID);
        System.out.println("用户请求地址：" + url);
        System.out.println("核验结果："+urls.contains(url));
        // TODO 核验用户请求
        return true;
    }


}
