package cn.tworice.verify.service;

import java.util.Map;

public interface OnlineService {

    /**
     * 使指定用户下线
     * @param key 用户ID
     * @return boolean 是否下线成功
     * @author 二饭 [2022/9/24]
     **/
    boolean offline(String key);

    /**
     * 获取当前在线的用户列表
     * @return java.util.Map<java.lang.String, java.lang.String>
     * @author 二饭 [2022/9/24]
     **/
    Map<String, String> onlineMap();

    /**
     * 判断用户是否在线
     * @param key 用户ID
     * @param token 用户Token
     * @return boolean
     * @author 二饭 [2022/9/24]
     **/
    boolean exist(String key,String token);

    /**
     * 用户上线
     * @param key 用户ID
     * @param token 用户Token
     * @return boolean
     * @author 二饭 [2022/9/24]
     **/
    boolean online(String key, String token);

    boolean addAdminResources(String adminID, String[] list);

    boolean authAdminResource(String adminID, String url);

}
