/*
 * Decompiled with CFR 0.152.
 */
package cn.tworice.verify.auth;

import cn.tworice.verify.service.OnlineService;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"verify"})
public class AuthServer {
    @Autowired
    private OnlineService onlineService;

    @PutMapping(value={"online"})
    public boolean online(String key, String token) {
        return this.onlineService.online(key, token);
    }

    @GetMapping(value={"onlineMap"})
    public Map<String, String> onlineMap() {
        return this.onlineService.onlineMap();
    }

    @PostMapping(value={"offline"})
    public boolean offline(String key) {
        return this.onlineService.offline(key);
    }

    @PostMapping(value={"exist"})
    public boolean exist(String key, String token) {
        return this.onlineService.exist(key, token);
    }

    @PostMapping(value={"auth"})
    public boolean auth(String key, String token, String url) {
        if (this.onlineService.exist(key, token)) {
            return this.onlineService.authAdminResource(key, url);
        }
        return false;
    }

    @PostMapping(value={"cache"})
    public boolean addAdminResources(@RequestParam(value="adminID") String adminID, @RequestParam(value="resources") String[] resources) {
        return this.onlineService.addAdminResources(adminID, resources);
    }
}

