/*
 * Decompiled with CFR 0.152.
 */
package cn.tworice.system.service.user;

import cn.hutool.core.util.DesensitizedUtil;
import cn.tworice.common.util.excel.InductsListenerService;
import cn.tworice.mybatis.query.LambdaQueryWrapperX;
import cn.tworice.mybatis.query.MPJLambdaWrapperX;
import cn.tworice.mybatis.vo.PageParam;
import cn.tworice.system.dao.user.SystemUserInfoDao;
import cn.tworice.system.dao.user.UserDao;
import cn.tworice.system.dao.user.po.SystemUserInfoDO;
import cn.tworice.system.dao.user.po.UserDO;
import cn.tworice.system.dao.user.po.UserInfoDTO;
import cn.tworice.system.service.role.RoleService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.yulichang.interfaces.MPJBaseJoin;
import com.github.yulichang.wrapper.MPJLambdaWrapper;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class SystemUserInfoService
extends ServiceImpl<SystemUserInfoDao, SystemUserInfoDO>
implements InductsListenerService<SystemUserInfoDO> {
    @Resource
    private SystemUserInfoDao dao;
    @Resource
    private UserDao userDao;
    @Resource
    private RoleService roleService;

    public Map<String, Object> getPage(PageParam pageParam, SystemUserInfoDO entity) {
        return this.dao.selectPage(pageParam, (Wrapper)new LambdaQueryWrapperX().eqIfPresent(SystemUserInfoDO::getId, (Object)entity.getId()).eqIfPresent(SystemUserInfoDO::getUserId, (Object)entity.getUserId()));
    }

    public boolean saveBatch(List<SystemUserInfoDO> list) {
        list.forEach(item -> item.setCreateTime(System.currentTimeMillis()));
        return this.dao.insertBatch(list, list.size());
    }

    public UserInfoDTO info(String userId) {
        UserInfoDTO userInfoDTO = (UserInfoDTO)this.userDao.selectJoinOne(UserInfoDTO.class, (MPJBaseJoin)((MPJLambdaWrapper)new MPJLambdaWrapperX().select(new SFunction[]{UserDO::getNickName}).selectAll(SystemUserInfoDO.class).leftJoin(SystemUserInfoDO.class, SystemUserInfoDO::getUserId, UserDO::getId)).eq(UserDO::getId, (Object)userId));
        userInfoDTO.setRoles(this.roleService.getRoleListByUid(userId));
        return userInfoDTO;
    }

    public SystemUserInfoDO blurInfo(String userId) {
        UserInfoDTO info = this.info(userId);
        info.setAdminPhone(DesensitizedUtil.mobilePhone((String)info.getAdminPhone()));
        info.setAdminEmail(DesensitizedUtil.email((String)info.getAdminEmail()));
        return info;
    }

    public void removeByAdminId(String[] ids) {
        this.dao.delete((Wrapper)new LambdaQueryWrapperX().in(SystemUserInfoDO::getUserId, Arrays.asList(ids)));
    }
}

