/*
 * Decompiled with CFR 0.152.
 */
package cn.tworice.system.controller.resources;

import cn.tworice.common.vo.RequestResult;
import cn.tworice.system.dao.resource.po.ResourcesDO;
import cn.tworice.system.service.login.LoginService;
import cn.tworice.system.service.resources.ResourcesService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"admin/system/resources"})
@CrossOrigin
@Api(tags={"\u7cfb\u7edf\u83dc\u5355\u8d44\u6e90"})
public class ResourcesController {
    private static final Logger log = LoggerFactory.getLogger(ResourcesController.class);
    @Resource
    private ResourcesService service;
    @Autowired
    private LoginService loginService;

    @ApiOperation(value="\u7f16\u8f91\u6216\u6dfb\u52a0\u8d44\u6e90")
    @PutMapping(value={"edit"})
    @ApiImplicitParam(name="id", value="\u5982\u4fee\u6539\uff0c\u8bf7\u6dfb\u52a0ID", dataType="int", dataTypeClass=Integer.class)
    public RequestResult editResources(ResourcesDO resources) {
        if (this.service.editResource(resources) == 1) {
            return RequestResult.success();
        }
        return RequestResult.error();
    }

    @DeleteMapping(value={"del"})
    @ApiOperation(value="\u5220\u9664\u8d44\u6e90")
    @ApiImplicitParam(name="ids", value="\u8d44\u6e90ID", required=true, dataType="Array[Integer]", dataTypeClass=Integer[].class)
    public RequestResult delResources(Integer[] ids) {
        return RequestResult.success((String)("\u5220\u9664" + this.service.delResources(ids) + "\u6761"));
    }

    @GetMapping(value={"conditionQuery"})
    @ApiOperation(value="\u901a\u8fc7\u6761\u4ef6\u67e5\u8be2\u8d44\u6e90\u5185\u5bb9")
    public RequestResult conditionQueryResources(String name) {
        return RequestResult.success().appendData("list", this.service.selectResources(name));
    }

    @GetMapping(value={"list"})
    @ApiOperation(value="\u83b7\u53d6\u6240\u6709\u8d44\u6e90\u5217\u8868")
    public RequestResult resourcesList() {
        return RequestResult.success().appendData("resourceList", this.loginService.getResourcesAll("1"));
    }
}

