package cn.tworice.system.service.feedback;

import cn.tworice.mybatis.query.LambdaQueryWrapperX;
import cn.tworice.common.util.excel.InductsListenerService;
import cn.tworice.mybatis.query.MPJLambdaWrapperX;
import cn.tworice.system.dao.feedback.SystemFeedbackTypeDao;
import cn.tworice.system.dao.feedback.dto.FeedbackDTO;
import cn.tworice.system.dao.feedback.dto.SystemFeedbackTypeDTO;
import cn.tworice.system.dao.feedback.po.SystemFeedbackDO;
import cn.tworice.system.dao.feedback.po.SystemFeedbackTypeDO;
import cn.tworice.mybatis.vo.PageParam;
import cn.tworice.system.dao.role.po.RoleDO;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Arrays;
import java.util.Map;
import javax.annotation.Resource;

@Service
public class SystemFeedbackTypeService implements InductsListenerService<SystemFeedbackTypeDO> {
    @Resource
    private SystemFeedbackTypeDao dao;

    public Map<String, Object> getPage(PageParam pageParam, SystemFeedbackTypeDO entity) {
        return dao.selectJoinPage(pageParam, SystemFeedbackTypeDTO.class, new MPJLambdaWrapperX<SystemFeedbackTypeDO>()
                .eqIfPresent(SystemFeedbackTypeDO::getId, entity.getId())
                .eqIfPresent(SystemFeedbackTypeDO::getCreator, entity.getCreator())
                .selectAll(SystemFeedbackTypeDO.class)
                .leftJoin(RoleDO.class, RoleDO::getId, SystemFeedbackTypeDO::getTypeLevel)
                .selectAs(RoleDO::getRoleName, SystemFeedbackTypeDTO::getRoleName)

                .orderByDesc(SystemFeedbackTypeDO::getCreateTime));
    }

    public int set(SystemFeedbackTypeDO entity) {
        if (entity.getId() == null) {
            return dao.insert(entity);
        } else {
            return dao.updateById(entity);
        }
    }

    public int del(Integer[] ids) {
        return dao.deleteBatchIds(Arrays.asList(ids));
    }

    @Override
    public boolean saveBatch(List<SystemFeedbackTypeDO> list) {
        return dao.insertBatch(list, list.size());
    }

    public SystemFeedbackTypeDO info(int id) {
        return dao.selectById(id);
    }

    /**
     * 通过反馈类型的状态码获取反馈类型列表
     *
     * @param showStateCode 反馈类型状态码
     * @return 反馈类型列表
     */
    public List<SystemFeedbackTypeDO> getTypeListByState(Integer showStateCode) {
        return dao.selectList(new LambdaQueryWrapperX<SystemFeedbackTypeDO>().eqIfPresent(SystemFeedbackTypeDO::getTypeState, showStateCode));
    }

}