package cn.tworice.system.dao.user.po;

import cn.tworice.mybatis.po.BasicDO;
import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;

/**
 * 账号实体类
 * @author 二饭[2024年8月7日]
 */
@Data
@EqualsAndHashCode(callSuper = true)
@TableName(value = "system_user")
public class UserDO extends BasicDO implements Serializable {
    private static final long serialVersionUID = -7332206127189803779L;
    @TableId(type = IdType.ASSIGN_UUID)
    private String id;

    @ExcelProperty("登录账号")
    private String loginName;

    @ExcelProperty("登录密码")
    private String passWord;

    @ExcelProperty("姓名")
    private String nickName;

    @ExcelProperty("账号状态")
    private Integer status;

    @ExcelProperty("邀请码")
    private String inviteCode;

    @ExcelProperty("邀请人")
    private String inviterId;
}
